/*
 * Decompiled with CFR 0.152.
 */
package g0201_0300.s0211_design_add_and_search_words_data_structure;

public class WordDictionary {
    private Node root = new Node('a');

    public void addWord(String word) {
        Node node = this.root;
        for (int i = 0; i < word.length(); ++i) {
            char ch = word.charAt(i);
            if (!node.isChild(ch)) {
                node.addChild(ch);
            }
            node = node.getChild(ch);
        }
        node.isEnd = true;
    }

    public boolean search(String word) {
        return this.dfs(this.root, word, 0);
    }

    public boolean dfs(Node root, String word, int index) {
        if (root == null) {
            return false;
        }
        if (index == word.length()) {
            return root.isEnd;
        }
        char ch = word.charAt(index);
        if (ch == '.') {
            for (Node child : root.childs) {
                boolean found = this.dfs(child, word, index + 1);
                if (!found) continue;
                return true;
            }
            return false;
        }
        if (!root.isChild(ch)) {
            return false;
        }
        return this.dfs(root.getChild(ch), word, index + 1);
    }

    private static class Node {
        char value;
        boolean isEnd;
        Node[] childs;

        Node(char value) {
            this.value = value;
            this.isEnd = false;
            this.childs = new Node[26];
        }

        Node getChild(char ch) {
            return this.childs[ch - 97];
        }

        boolean isChild(char ch) {
            return this.getChild(ch) != null;
        }

        void addChild(char ch) {
            this.childs[ch - 97] = new Node(ch);
        }
    }
}

