/*
 * Decompiled with CFR 0.152.
 */
package s0037_sudoku_solver;

import java.util.ArrayList;
import java.util.List;

public class Solution {
    List<int[]> emptyCells = new ArrayList<int[]>();
    int[] rows = new int[9];
    int[] cols = new int[9];
    int[] boxes = new int[9];

    public void solveSudoku(char[][] board) {
        for (int r = 0; r < 9; ++r) {
            for (int c = 0; c < 9; ++c) {
                if (board[r][c] == '.') {
                    this.emptyCells.add(new int[]{r, c});
                    continue;
                }
                int val = board[r][c] - 48;
                int boxPos = r / 3 * 3 + c / 3;
                int n = r;
                this.rows[n] = this.rows[n] | 1 << val;
                int n2 = c;
                this.cols[n2] = this.cols[n2] | 1 << val;
                int n3 = boxPos;
                this.boxes[n3] = this.boxes[n3] | 1 << val;
            }
        }
        this.backtracking(board, 0);
    }

    boolean backtracking(char[][] board, int i) {
        if (i == this.emptyCells.size()) {
            return true;
        }
        int r = this.emptyCells.get(i)[0];
        int c = this.emptyCells.get(i)[1];
        int boxPos = r / 3 * 3 + c / 3;
        for (int val = 1; val <= 9; ++val) {
            if (this.hasBit(this.rows[r], val) || this.hasBit(this.cols[c], val) || this.hasBit(this.boxes[boxPos], val)) continue;
            board[r][c] = (char)(48 + val);
            int oldRow = this.rows[r];
            int oldCol = this.cols[c];
            int oldBox = this.boxes[boxPos];
            int n = r;
            this.rows[n] = this.rows[n] | 1 << val;
            int n2 = c;
            this.cols[n2] = this.cols[n2] | 1 << val;
            int n3 = boxPos;
            this.boxes[n3] = this.boxes[n3] | 1 << val;
            if (this.backtracking(board, i + 1)) {
                return true;
            }
            this.rows[r] = oldRow;
            this.cols[c] = oldCol;
            this.boxes[boxPos] = oldBox;
        }
        return false;
    }

    boolean hasBit(int x, int k) {
        return (x >> k & 1) == 1;
    }
}

