/*
 * Decompiled with CFR 0.152.
 */
package g0201_0300.s0273_integer_to_english_words;

public class Solution {
    private String[] ones = new String[]{"One ", "Two ", "Three ", "Four ", "Five ", "Six ", "Seven ", "Eight ", "Nine "};
    private String[] teens = new String[]{"Ten ", "Eleven ", "Twelve ", "Thirteen ", "Fourteen ", "Fifteen ", "Sixteen ", "Seventeen ", "Eighteen ", "Nineteen "};
    private String[] twenties = new String[]{"Twenty ", "Thirty ", "Forty ", "Fifty ", "Sixty ", "Seventy ", "Eighty ", "Ninety "};
    private String zero = "Zero";
    private String hundred = "Hundred ";
    private String thousand = "Thousand ";
    private String million = "Million ";
    private String billion = "Billion ";

    public String numberToWords(int num) {
        if (num == 0) {
            return this.zero;
        }
        StringBuilder sb = new StringBuilder();
        this.processThreeDigits(sb, num / 1000000000, this.billion);
        this.processThreeDigits(sb, num / 1000000, this.million);
        this.processThreeDigits(sb, num / 1000, this.thousand);
        this.processThreeDigits(sb, num, null);
        return sb.toString().trim();
    }

    private void processThreeDigits(StringBuilder sb, int input, String name) {
        int threeDigit = input % 1000;
        if (threeDigit > 0) {
            if (threeDigit / 100 > 0) {
                sb.append(this.ones[threeDigit / 100 - 1]);
                sb.append(this.hundred);
            }
            if (threeDigit % 100 >= 20) {
                sb.append(this.twenties[threeDigit % 100 / 10 - 2]);
                if (threeDigit % 10 > 0) {
                    sb.append(this.ones[threeDigit % 10 - 1]);
                }
            } else if (threeDigit % 100 >= 10 && threeDigit % 100 < 20) {
                sb.append(this.teens[threeDigit % 10]);
            } else if (threeDigit % 100 > 0 && threeDigit % 100 < 10) {
                sb.append(this.ones[threeDigit % 10 - 1]);
            }
            if (name != null) {
                sb.append(name);
            }
        }
    }
}

