/*
 * Decompiled with CFR 0.152.
 */
package g1301_1400.s1307_verbal_arithmetic_puzzle;

import java.util.Arrays;

public class Solution {
    private int[] map;
    private char[][] grid;
    private boolean solved;
    private boolean[] usedDigit;
    private boolean[] mustNotBeZero;
    private int cols;
    private int resultRow;

    public boolean isSolvable(String[] words, String result) {
        this.solved = false;
        int rows = words.length + 1;
        this.cols = result.length();
        this.grid = new char[rows][this.cols];
        this.mustNotBeZero = new boolean[26];
        this.usedDigit = new boolean[10];
        this.resultRow = rows - 1;
        this.map = new int[26];
        Arrays.fill(this.map, -1);
        int maxLength = 0;
        for (int i = 0; i < words.length; ++i) {
            int j = words[i].length();
            if (j > maxLength) {
                maxLength = j;
            }
            if (j > 1) {
                this.mustNotBeZero[words[i].charAt((int)0) - 65] = true;
            }
            if (j > this.cols) {
                return false;
            }
            char[] cArray = words[i].toCharArray();
            int n = cArray.length;
            for (int k = 0; k < n; ++k) {
                char c = cArray[k];
                this.grid[i][--j] = c;
            }
        }
        if (maxLength + 1 < this.cols) {
            return false;
        }
        int j = this.cols;
        if (j > 1) {
            this.mustNotBeZero[result.charAt((int)0) - 65] = true;
        }
        for (char c : result.toCharArray()) {
            this.grid[this.resultRow][--j] = c;
        }
        this.backtrack(0, 0, 0);
        return this.solved;
    }

    private boolean canPlace(int ci, int d) {
        return !this.usedDigit[d] && this.map[ci] == -1 || this.map[ci] == d;
    }

    private void placeNum(int ci, int d) {
        this.usedDigit[d] = true;
        this.map[ci] = d;
    }

    private void removeNum(int ci, int d) {
        this.usedDigit[d] = false;
        this.map[ci] = -1;
    }

    private void placeNextNum(int r, int c, int sum) {
        if (r == this.resultRow && c == this.cols - 1) {
            this.solved = sum == 0;
        } else if (r == this.resultRow) {
            this.backtrack(0, c + 1, sum);
        } else {
            this.backtrack(r + 1, c, sum);
        }
    }

    private void backtrack(int r, int c, int sum) {
        char unused = '\u0000';
        if (this.grid[r][c] == unused) {
            this.placeNextNum(r, c, sum);
        } else {
            int ci = this.grid[r][c] - 65;
            if (r == this.resultRow) {
                int d = sum % 10;
                if (this.map[ci] == -1) {
                    if (this.canPlace(ci, d)) {
                        this.placeNum(ci, d);
                        this.placeNextNum(r, c, sum / 10);
                        if (this.solved) {
                            return;
                        }
                        this.removeNum(ci, d);
                    }
                } else if (this.map[ci] == d) {
                    this.placeNextNum(r, c, sum / 10);
                }
            } else if (this.map[ci] == -1) {
                int d;
                int n = d = this.mustNotBeZero[ci] ? 1 : 0;
                while (d < 10) {
                    if (this.canPlace(ci, d)) {
                        this.placeNum(ci, d);
                        this.placeNextNum(r, c, sum + d);
                        if (this.solved) {
                            return;
                        }
                        this.removeNum(ci, d);
                    }
                    ++d;
                }
            } else {
                this.placeNextNum(r, c, sum + this.map[ci]);
            }
        }
    }
}

