/*
 * Decompiled with CFR 0.152.
 */
package g1401_1500.s1453_maximum_number_of_darts_inside_of_a_circular_dartboard;

import java.util.ArrayList;
import java.util.Collections;

public class Solution {
    private int getPointsInside(int i, double r, int n, int[][] points, double[][] dis) {
        ArrayList<Angle> angles = new ArrayList<Angle>(2 * n);
        for (int j = 0; j < n; ++j) {
            if (i == j || !(dis[i][j] <= 2.0 * r)) continue;
            double b = Math.acos(dis[i][j] / (2.0 * r));
            double a = Math.atan2((double)points[j][1] - (double)points[i][1] * 1.0, (double)points[j][0] * 1.0 - (double)points[i][0]);
            double alpha = a - b;
            double beta = a + b;
            angles.add(new Angle(alpha, true));
            angles.add(new Angle(beta, false));
        }
        Collections.sort(angles);
        int count = 1;
        int res = 1;
        for (Angle a : angles) {
            count = a.enter ? ++count : --count;
            if (count <= res) continue;
            res = count;
        }
        return res;
    }

    public int numPoints(int[][] points, int r) {
        int n = points.length;
        double[][] dis = new double[n][n];
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d = Math.sqrt(Math.pow((double)points[i][0] * 1.0 - (double)points[j][0], 2.0) + Math.pow((double)points[i][1] * 1.0 - (double)points[j][1], 2.0));
                dis[j][i] = d;
                dis[i][j] = d;
            }
        }
        int ans = 0;
        for (int i = 0; i < n; ++i) {
            ans = Math.max(ans, this.getPointsInside(i, r, n, points, dis));
        }
        return ans;
    }

    private static class Angle
    implements Comparable<Angle> {
        double a;
        boolean enter;

        Angle(double a, boolean enter) {
            this.a = a;
            this.enter = enter;
        }

        @Override
        public int compareTo(Angle o) {
            if (this.a > o.a) {
                return 1;
            }
            if (this.a < o.a) {
                return -1;
            }
            if (this.enter == o.enter) {
                return 0;
            }
            if (this.enter) {
                return -1;
            }
            return 1;
        }
    }
}

