/*
 * Decompiled with CFR 0.152.
 */
package g2101_2200.s2135_count_words_obtained_after_adding_a_letter;

import java.util.HashSet;
import java.util.Set;

public class Solution {
    private Set<Integer> set;

    private void preprocess(String[] words) {
        this.set = new HashSet<Integer>();
        for (String word : words) {
            int bitMap = this.getBitMap(word);
            this.set.add(bitMap);
        }
    }

    private boolean matches(int bitMap) {
        return this.set.contains(bitMap);
    }

    private int getBitMap(String word) {
        int result = 0;
        for (int i = 0; i < word.length(); ++i) {
            int position = word.charAt(i) - 97;
            result |= 1 << position;
        }
        return result;
    }

    private int addBit(int bitMap, char c) {
        int position = c - 97;
        return bitMap |= 1 << position;
    }

    private int removeBit(int bitMap, char c) {
        int position = c - 97;
        return bitMap &= ~(1 << position);
    }

    public int wordCount(String[] startWords, String[] targetWords) {
        if (startWords == null || startWords.length == 0) {
            return 0;
        }
        if (targetWords == null || targetWords.length == 0) {
            return 0;
        }
        this.preprocess(startWords);
        int count = 0;
        block0: for (String word : targetWords) {
            int bitMap = this.getBitMap(word);
            for (int i = 0; i < word.length(); ++i) {
                bitMap = this.removeBit(bitMap, word.charAt(i));
                if (i > 0) {
                    bitMap = this.addBit(bitMap, word.charAt(i - 1));
                }
                if (!this.matches(bitMap)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }
}

