/*
 * Decompiled with CFR 0.152.
 */
package g0601_0700.s0622_design_circular_queue;

public class MyCircularQueue {
    private final DoubleLinkedNode dumyHead = new DoubleLinkedNode(0);
    private final int maxSize;
    private int size = 0;

    public MyCircularQueue(int k) {
        this.maxSize = k;
        this.dumyHead.left = this.dumyHead;
        this.dumyHead.right = this.dumyHead;
    }

    public boolean enQueue(int value) {
        if (this.size == this.maxSize) {
            return false;
        }
        DoubleLinkedNode node = new DoubleLinkedNode(value);
        DoubleLinkedNode right = this.dumyHead.right;
        this.dumyHead.right = node;
        node.left = this.dumyHead;
        node.right = right;
        right.left = node;
        ++this.size;
        return true;
    }

    public boolean deQueue() {
        if (this.size == 0) {
            return false;
        }
        DoubleLinkedNode left = this.dumyHead.left;
        this.dumyHead.left = left.left;
        this.dumyHead.left.right = this.dumyHead;
        --this.size;
        return true;
    }

    public int rear() {
        if (this.size == 0) {
            return -1;
        }
        return this.dumyHead.right.val;
    }

    public int front() {
        if (this.size == 0) {
            return -1;
        }
        return this.dumyHead.left.val;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.maxSize;
    }

    static class DoubleLinkedNode {
        private final int val;
        private DoubleLinkedNode left;
        private DoubleLinkedNode right;

        public DoubleLinkedNode(int val) {
            this.val = val;
        }
    }
}

