/*
 * Decompiled with CFR 0.152.
 */
package g1301_1400.s1348_tweet_counts_per_frequency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TweetCounts {
    private static final int MINUTE = 60;
    private static final int HOUR = 3600;
    private static final int DAY = 86400;
    private final Map<String, Map<Integer, Map<Integer, Map<Integer, List<Integer>>>>> store = new HashMap<String, Map<Integer, Map<Integer, Map<Integer, List<Integer>>>>>();

    public void recordTweet(String tweetName, int time) {
        int d = time / 86400;
        int h = (time - d * 86400) / 3600;
        int m = (time - d * 86400 - h * 3600) / 60;
        Map dstore = this.store.computeIfAbsent(tweetName, k -> new HashMap());
        Map hstore = dstore.computeIfAbsent(d, k -> new HashMap());
        Map mstore = hstore.computeIfAbsent(h, k -> new HashMap());
        mstore.computeIfAbsent(m, k -> new ArrayList()).add(time);
    }

    public List<Integer> getTweetCountsPerFrequency(String freq, String tweetName, int startTime, int endTime) {
        int sfreq = this.convFreqToSecond(freq);
        Map<Integer, Map<Integer, Map<Integer, List<Integer>>>> dstore = this.store.get(tweetName);
        int[] chunks = new int[(endTime - startTime) / sfreq + 1];
        int sd = startTime / 86400;
        int ed = endTime / 86400;
        for (int d = sd; d <= ed; ++d) {
            if (!dstore.containsKey(d)) continue;
            int sh = startTime <= d * 86400 ? 0 : (startTime - d * 86400) / 3600;
            int eh = endTime > (d + 1) * 86400 ? 24 : (endTime - d * 86400) / 3600 + 1;
            Map<Integer, Map<Integer, List<Integer>>> hstore = dstore.get(d);
            for (int h = sh; h < eh; ++h) {
                if (!hstore.containsKey(h)) continue;
                int sm = startTime <= d * 86400 + h * 3600 ? 0 : (startTime - d * 86400 - h * 3600) / 60;
                int em = endTime > d * 86400 + (h + 1) * 3600 ? 60 : (endTime - d * 86400 - h * 3600) / 60 + 1;
                Map<Integer, List<Integer>> mstore = hstore.get(h);
                for (int m = sm; m <= em; ++m) {
                    if (!mstore.containsKey(m)) continue;
                    for (Integer rc : mstore.get(m)) {
                        if (startTime > rc || rc > endTime) continue;
                        int n = (rc - startTime) / sfreq;
                        chunks[n] = chunks[n] + 1;
                    }
                }
            }
        }
        ArrayList<Integer> ans = new ArrayList<Integer>();
        for (int chunk : chunks) {
            ans.add(chunk);
        }
        return ans;
    }

    private int convFreqToSecond(String freq) {
        switch (freq) {
            case "minute": {
                return 60;
            }
            case "hour": {
                return 3600;
            }
            case "day": {
                return 86400;
            }
        }
        return 0;
    }
}

