/*
 * Decompiled with CFR 0.152.
 */
package g1601_1700.s1627_graph_connectivity_with_threshold;

import java.util.ArrayList;
import java.util.List;

public class Solution {
    public List<Boolean> areConnected(int n, int threshold, int[][] queries) {
        if (n < 1 || queries == null || queries.length == 0) {
            return new ArrayList<Boolean>();
        }
        DisjointSetUnion set = new DisjointSetUnion(n + 1);
        int edges = queries.length;
        for (int i = threshold + 1; i <= n; ++i) {
            int k = n / i;
            int x = i;
            for (int j = 2; j <= k; ++j) {
                set.union(i, x += i);
            }
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>(edges);
        for (int[] query : queries) {
            result.add(set.find(query[0]) == set.find(query[1]));
        }
        return result;
    }

    private static class DisjointSetUnion {
        private final int[] rank;
        private final int[] parent;

        public DisjointSetUnion(int n) {
            this.rank = new int[n];
            this.parent = new int[n];
            for (int i = 0; i < n; ++i) {
                this.rank[i] = 1;
                this.parent[i] = i;
            }
        }

        public int find(int u) {
            int x = u;
            while (x != this.parent[x]) {
                x = this.parent[x];
            }
            this.parent[u] = x;
            return x;
        }

        public void union(int u, int v) {
            int y;
            int x;
            if (u != v && (x = this.find(u)) != (y = this.find(v))) {
                if (this.rank[x] > this.rank[y]) {
                    int n = x;
                    this.rank[n] = this.rank[n] + this.rank[y];
                    this.parent[y] = x;
                } else {
                    int n = y;
                    this.rank[n] = this.rank[n] + this.rank[x];
                    this.parent[x] = y;
                }
            }
        }
    }
}

