/*
 * Decompiled with CFR 0.152.
 */
package g1201_1300.s1268_search_suggestions_system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Solution {
    public List<List<String>> suggestedProducts(String[] products, String searchWord) {
        Trie trie = new Trie();
        Arrays.sort(products);
        for (String p : products) {
            trie.insert(p);
        }
        return trie.getResult(searchWord);
    }

    static class Trie {
        Node root = new Node();

        void insert(String word) {
            Node curr = this.root;
            for (int i = 0; i < word.length(); ++i) {
                char c = word.charAt(i);
                if (!curr.containsKey(c)) {
                    curr.put(c, new Node());
                }
                curr = curr.get(c);
                curr.addToList(word);
            }
        }

        List<List<String>> getResult(String searchWord) {
            Node curr = this.root;
            ArrayList<List<String>> res = new ArrayList<List<String>>();
            for (int i = 0; i < searchWord.length(); ++i) {
                char c = searchWord.charAt(i);
                ArrayList<String> temp = new ArrayList<String>();
                if (curr != null) {
                    curr = curr.get(c);
                }
                for (int j = 0; j < 3 && curr != null && j < curr.getList().size(); ++j) {
                    temp.add(curr.getList().get(j));
                }
                res.add(new ArrayList(temp));
            }
            return res;
        }
    }

    static class Node {
        Node[] links = new Node[26];
        List<String> list = new ArrayList<String>();

        boolean containsKey(char c) {
            return this.links[c - 97] != null;
        }

        Node get(char c) {
            return this.links[c - 97];
        }

        void put(char c, Node node) {
            this.links[c - 97] = node;
        }

        void addToList(String s) {
            this.list.add(s);
        }

        List<String> getList() {
            return this.list;
        }
    }
}

