/*
 * Decompiled with CFR 0.152.
 */
package g1601_1700.s1606_find_servers_that_handled_most_number_of_requests;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.TreeSet;

public class Solution {
    public List<Integer> busiestServers(int k, int[] arrival, int[] load) {
        int id;
        TreeSet<Integer> available = new TreeSet<Integer>();
        PriorityQueue<Server> busy = new PriorityQueue<Server>(Comparator.comparingInt(a -> a.busyTime));
        int[] requestCount = new int[k];
        int n = arrival.length;
        for (int id2 = 0; id2 < k; ++id2) {
            available.add(id2);
        }
        for (int i = 0; i < n; ++i) {
            int defaultServer = i % k;
            while (!busy.isEmpty() && busy.peek().busyTime <= arrival[i]) {
                Server top = busy.poll();
                available.add(top.id);
            }
            if (available.isEmpty()) continue;
            Integer nextServer = available.ceiling(defaultServer);
            nextServer = nextServer != null ? nextServer : available.ceiling(0);
            int requestEnd = arrival[i] + load[i];
            available.remove(nextServer);
            busy.add(new Server(nextServer, requestEnd));
            int n2 = nextServer;
            requestCount[n2] = requestCount[n2] + 1;
        }
        int maxRequests = Integer.MIN_VALUE;
        ArrayList<Integer> busiestServers = new ArrayList<Integer>();
        for (id = 0; id < k; ++id) {
            maxRequests = Math.max(maxRequests, requestCount[id]);
        }
        for (id = 0; id < k; ++id) {
            if (requestCount[id] != maxRequests) continue;
            busiestServers.add(id);
        }
        return busiestServers;
    }

    static class Server {
        final int id;
        final int busyTime;

        public Server(int id, int busyTime) {
            this.id = id;
            this.busyTime = busyTime;
        }
    }
}

