/*
 * Decompiled with CFR 0.152.
 */
package g1701_1800.s1735_count_ways_to_make_array_with_product;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Solution {
    private static final int MOD = 1000000007;
    private long[][] tri;
    private List<Integer> primes;

    public int[] waysToFillArray(int[][] queries) {
        int len = queries.length;
        int[] res = new int[len];
        this.primes = this.getPrimes(100);
        this.tri = this.getTri(10015, 15);
        for (int i = 0; i < len; ++i) {
            res[i] = this.calculate(queries[i][0], queries[i][1]);
        }
        return res;
    }

    private List<Integer> getPrimes(int limit) {
        boolean[] notPrime = new boolean[limit + 1];
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i = 2; i <= limit; ++i) {
            if (notPrime[i]) continue;
            res.add(i);
            for (int j = i * i; j <= limit; j += i) {
                notPrime[j] = true;
            }
        }
        return res;
    }

    private long[][] getTri(int m, int n) {
        long[][] res = new long[m + 1][n + 1];
        for (int i = 0; i <= m; ++i) {
            res[i][0] = 1L;
            for (int j = 1; j <= Math.min(n, i); ++j) {
                res[i][j] = (res[i - 1][j - 1] + res[i - 1][j]) % 1000000007L;
            }
        }
        return res;
    }

    private int calculate(int n, int target) {
        int prime;
        long res = 1L;
        Iterator<Integer> iterator = this.primes.iterator();
        while (iterator.hasNext() && (prime = iterator.next().intValue()) <= target) {
            int cnt = 0;
            while (target % prime == 0) {
                ++cnt;
                target /= prime;
            }
            res = res * this.tri[cnt + n - 1][cnt] % 1000000007L;
        }
        return target > 1 ? (int)(res * (long)n % 1000000007L) : (int)res;
    }
}

