/*
 * Decompiled with CFR 0.152.
 */
package g1901_2000.s1906_minimum_absolute_difference_queries;

import java.util.Arrays;
import java.util.BitSet;

public class Solution {
    public int[] minDifference(int[] nums, int[][] queries) {
        int len = nums.length;
        int qlen = queries.length;
        SegmentTree st = new SegmentTree(nums, len);
        int[] answer = new int[qlen];
        for (int i = 0; i < qlen; ++i) {
            answer[i] = st.findMinAbsDiff(queries[i][0], queries[i][1], 0, len - 1, 0);
        }
        return answer;
    }

    private static class SegmentTree {
        int len;
        int[] nums;
        Node[] tree;
        static final int INF = 200;

        SegmentTree(int[] nums, int len) {
            this.nums = Arrays.copyOf(nums, len);
            this.len = len;
            this.tree = new Node[4 * len];
            this.buildTree(0, len - 1, 0);
        }

        private void buildTree(int i, int j, int ti) {
            if (i <= j) {
                if (i == j) {
                    Node node = new Node();
                    node.bits = new BitSet(101);
                    node.bits.set(this.nums[i]);
                    node.minDiff = 200;
                    this.tree[ti] = node;
                } else {
                    int mid = i + (j - i) / 2;
                    this.buildTree(i, mid, 2 * ti + 1);
                    this.buildTree(mid + 1, j, 2 * ti + 2);
                    this.tree[ti] = this.combineNodes(this.tree[2 * ti + 1], this.tree[2 * ti + 2]);
                }
            }
        }

        private Node combineNodes(Node n1, Node n2) {
            Node node = new Node();
            if (n1.minDiff == 1 || n2.minDiff == 1) {
                node.minDiff = 1;
            } else {
                node.bits = new BitSet(101);
                node.bits.or(n1.bits);
                node.bits.or(n2.bits);
                node.minDiff = this.findMinDiff(node.bits);
            }
            return node;
        }

        private int findMinDiff(BitSet bits) {
            int next;
            int first = bits.nextSetBit(1);
            int minDiff = 200;
            while (first != -1 && ((next = bits.nextSetBit(first + 1)) == -1 || (minDiff = Math.min(minDiff, next - first)) != 1)) {
                first = next;
            }
            return minDiff;
        }

        private int findMinAbsDiff(int start, int end, int i, int j, int ti) {
            Node node = this.findMinAbsDiff2(start, end, i, j, ti);
            return node.minDiff == 200 ? -1 : node.minDiff;
        }

        private Node findMinAbsDiff2(int start, int end, int i, int j, int ti) {
            if (i == start && j == end) {
                return this.tree[ti];
            }
            int mid = i + (j - i) / 2;
            if (end <= mid) {
                return this.findMinAbsDiff2(start, end, i, mid, 2 * ti + 1);
            }
            if (start >= mid + 1) {
                return this.findMinAbsDiff2(start, end, mid + 1, j, 2 * ti + 2);
            }
            Node left = this.findMinAbsDiff2(start, mid, i, mid, 2 * ti + 1);
            Node right = this.findMinAbsDiff2(mid + 1, end, mid + 1, j, 2 * ti + 2);
            return this.combineNodes(left, right);
        }

        static class Node {
            BitSet bits;
            int minDiff;

            Node() {
            }
        }
    }
}

