/*
 * Decompiled with CFR 0.152.
 */
package g2901_3000.s2920_maximum_points_after_collecting_coins_from_all_nodes;

import java.util.ArrayList;
import java.util.List;

public class Solution {
    private List<Integer>[] adjList;
    private int[] coins;
    private int k;
    private int[][] dp;

    private void init(int[][] edges, int[] coins, int k) {
        int n = coins.length;
        this.adjList = new List[n];
        for (int v = 0; v < n; ++v) {
            this.adjList[v] = new ArrayList<Integer>();
        }
        for (int[] edge : edges) {
            int u = edge[0];
            int v = edge[1];
            this.adjList[u].add(v);
            this.adjList[v].add(u);
        }
        this.coins = coins;
        this.k = k;
        this.dp = new int[n][14];
        for (int v = 0; v < n; ++v) {
            for (int numOfWay2Parents = 0; numOfWay2Parents < 14; ++numOfWay2Parents) {
                this.dp[v][numOfWay2Parents] = -1;
            }
        }
    }

    private int rec(int v, int p, int numOfWay2Parents) {
        if (numOfWay2Parents >= 14) {
            return 0;
        }
        if (this.dp[v][numOfWay2Parents] == -1) {
            int coinsV = this.coins[v] / (1 << numOfWay2Parents);
            int s0 = coinsV - this.k;
            int s1 = coinsV / 2;
            for (int child : this.adjList[v]) {
                if (child == p) continue;
                s0 += this.rec(child, v, numOfWay2Parents);
                s1 += this.rec(child, v, numOfWay2Parents + 1);
            }
            this.dp[v][numOfWay2Parents] = Math.max(s0, s1);
        }
        return this.dp[v][numOfWay2Parents];
    }

    public int maximumPoints(int[][] edges, int[] coins, int k) {
        this.init(edges, coins, k);
        return this.rec(0, -1, 0);
    }
}

