/*
 * Decompiled with CFR 0.152.
 */
package g3101_3200.s3187_peaks_in_array;

import java.util.ArrayList;
import java.util.List;

public class Solution {
    public List<Integer> countOfPeaks(int[] nums, int[][] queries) {
        boolean[] peaks = new boolean[nums.length];
        int[] binaryIndexedTree = new int[Integer.highestOneBit(peaks.length) * 2 + 1];
        for (int i = 1; i < peaks.length - 1; ++i) {
            if (nums[i] <= Math.max(nums[i - 1], nums[i + 1])) continue;
            peaks[i] = true;
            this.update(binaryIndexedTree, i + 1, 1);
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int[] query : queries) {
            int value;
            if (query[0] == 1) {
                int leftIndex = query[1];
                int rightIndex = query[2];
                result.add(this.computeRangeSum(binaryIndexedTree, leftIndex + 2, rightIndex));
                continue;
            }
            int index = query[1];
            nums[index] = value = query[2];
            for (int i = -1; i <= 1; ++i) {
                boolean peak;
                int affected = index + i;
                if (affected < 1 || affected > nums.length - 2) continue;
                boolean bl = peak = nums[affected] > Math.max(nums[affected - 1], nums[affected + 1]);
                if (peak == peaks[affected]) continue;
                if (peak) {
                    this.update(binaryIndexedTree, affected + 1, 1);
                } else {
                    this.update(binaryIndexedTree, affected + 1, -1);
                }
                peaks[affected] = peak;
            }
        }
        return result;
    }

    private int computeRangeSum(int[] binaryIndexedTree, int beginIndex, int endIndex) {
        return beginIndex <= endIndex ? this.query(binaryIndexedTree, endIndex) - this.query(binaryIndexedTree, beginIndex - 1) : 0;
    }

    private int query(int[] binaryIndexedTree, int index) {
        int result = 0;
        while (index != 0) {
            result += binaryIndexedTree[index];
            index -= index & -index;
        }
        return result;
    }

    private void update(int[] binaryIndexedTree, int index, int delta) {
        while (index < binaryIndexedTree.length) {
            int n = index;
            binaryIndexedTree[n] = binaryIndexedTree[n] + delta;
            index += index & -index;
        }
    }
}

