/*
 * Decompiled with CFR 0.152.
 */
package g1301_1400.s1396_design_underground_system;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class UndergroundSystem {
    private Map<String, double[]> averageTimeMap = new HashMap<String, double[]>();
    private Map<Integer, LinkedList<StationAndTime>> travelerMap = new HashMap<Integer, LinkedList<StationAndTime>>();

    public void checkIn(int id, String stationName, int t) {
        this.travelerMap.putIfAbsent(id, new LinkedList());
        this.travelerMap.get(id).add(new StationAndTime(stationName, t));
    }

    public void checkOut(int id, String stationName, int t) {
        LinkedList<StationAndTime> list = this.travelerMap.get(id);
        StationAndTime stationAndTime = list.getLast();
        String startToEndStation = stationAndTime.getStation() + "->" + stationName;
        int duration = t - stationAndTime.getTime();
        if (this.averageTimeMap.containsKey(startToEndStation)) {
            double[] pair = this.averageTimeMap.get(startToEndStation);
            double newAverage = (pair[0] * pair[1] + (double)duration) / (pair[1] + 1.0);
            this.averageTimeMap.put(startToEndStation, new double[]{newAverage, pair[1] + 1.0});
        } else {
            this.averageTimeMap.put(startToEndStation, new double[]{duration, 1.0});
        }
    }

    public double getAverageTime(String startStation, String endStation) {
        return this.averageTimeMap.get(startStation + "->" + endStation)[0];
    }

    private static class StationAndTime {
        String stationName;
        int t;

        public StationAndTime(String stationName, int t) {
            this.stationName = stationName;
            this.t = t;
        }

        public String getStation() {
            return this.stationName;
        }

        public int getTime() {
            return this.t;
        }
    }
}

