/*
 * Decompiled with CFR 0.152.
 */
package g3101_3200.s3165_maximum_sum_of_subsequence_with_non_adjacent_elements;

import java.util.stream.Stream;

public class Solution {
    private static final int MOD = 1000000007;

    public int maximumSumSubsequence(int[] nums, int[][] queries) {
        int ans = 0;
        SegTree segTree = new SegTree(nums);
        for (int[] q : queries) {
            int idx = q[0];
            int val = q[1];
            segTree.update(idx, val);
            ans = (ans + segTree.getMax()) % 1000000007;
        }
        return ans;
    }

    static class SegTree {
        private final Record[] seg;
        private final int[] nums;

        public SegTree(int[] nums) {
            this.nums = nums;
            this.seg = new Record[4 * nums.length];
            for (int i = 0; i < 4 * nums.length; ++i) {
                this.seg[i] = new Record();
            }
            this.build(0, nums.length - 1, 0);
        }

        private void build(int i, int j, int k) {
            if (i == j) {
                this.seg[k].takeFirstTakeLast = this.nums[i];
                return;
            }
            int mid = i + j >> 1;
            this.build(i, mid, 2 * k + 1);
            this.build(mid + 1, j, 2 * k + 2);
            this.merge(k);
        }

        private void merge(int k) {
            this.seg[k].takeFirstSkipLast = Math.max(this.seg[2 * k + 1].takeFirstSkipLast + this.seg[2 * k + 2].skipLast(), this.seg[2 * k + 1].takeFirstTakeLast + this.seg[2 * k + 2].skipFirstSkipLast);
            this.seg[k].takeFirstTakeLast = Math.max(this.seg[2 * k + 1].takeFirstSkipLast + this.seg[2 * k + 2].takeLast(), this.seg[2 * k + 1].takeFirstTakeLast + this.seg[2 * k + 2].skipFirstTakeLast);
            this.seg[k].skipFirstTakeLast = Math.max(this.seg[2 * k + 1].skipFirstSkipLast + this.seg[2 * k + 2].takeLast(), this.seg[2 * k + 1].skipFirstTakeLast + this.seg[2 * k + 2].skipFirstTakeLast);
            this.seg[k].skipFirstSkipLast = Math.max(this.seg[2 * k + 1].skipFirstSkipLast + this.seg[2 * k + 2].skipLast(), this.seg[2 * k + 1].skipFirstTakeLast + this.seg[2 * k + 2].skipFirstSkipLast);
        }

        public void update(int idx, int val) {
            int i = 0;
            int j = this.nums.length - 1;
            int k = 0;
            this.update(idx, val, k, i, j);
        }

        private void update(int idx, int val, int k, int i, int j) {
            if (i == j) {
                this.seg[k].takeFirstTakeLast = val;
                return;
            }
            int mid = i + j >> 1;
            if (idx <= mid) {
                this.update(idx, val, 2 * k + 1, i, mid);
            } else {
                this.update(idx, val, 2 * k + 2, mid + 1, j);
            }
            this.merge(k);
        }

        public int getMax() {
            return this.seg[0].getMax();
        }

        private static class Record {
            int takeFirstTakeLast;
            int takeFirstSkipLast;
            int skipFirstSkipLast;
            int skipFirstTakeLast;

            private Record() {
            }

            public Integer getMax() {
                return Stream.of(this.takeFirstSkipLast, this.takeFirstTakeLast, this.skipFirstSkipLast, this.skipFirstTakeLast).max(Integer::compare).orElse(null);
            }

            public Integer skipLast() {
                return Stream.of(this.takeFirstSkipLast, this.skipFirstSkipLast).max(Integer::compare).orElse(null);
            }

            public Integer takeLast() {
                return Stream.of(this.skipFirstTakeLast, this.takeFirstTakeLast).max(Integer::compare).orElse(null);
            }
        }
    }
}

