/*
 * Decompiled with CFR 0.152.
 */
package g3401_3500.s3425_longest_special_path;

import java.util.ArrayList;
import java.util.Arrays;

public class Solution {
    private ArrayList<int[]>[] adj;
    private int[] nums;
    private int[] dist;
    private int[] lastOccur;
    private ArrayList<Integer> pathStack;
    private int minIndex;
    private int maxLen;
    private int minNodesForMaxLen;

    public int[] longestSpecialPath(int[][] edges, int[] nums) {
        int n = nums.length;
        this.nums = nums;
        this.adj = new ArrayList[n];
        for (int i = 0; i < n; ++i) {
            this.adj[i] = new ArrayList();
        }
        for (int[] e : edges) {
            int u = e[0];
            int v = e[1];
            int w = e[2];
            this.adj[u].add(new int[]{v, w});
            this.adj[v].add(new int[]{u, w});
        }
        this.dist = new int[n];
        this.buildDist(0, -1, 0);
        int maxVal = 0;
        for (int val : nums) {
            if (val <= maxVal) continue;
            maxVal = val;
        }
        this.lastOccur = new int[maxVal + 1];
        Arrays.fill(this.lastOccur, -1);
        this.pathStack = new ArrayList();
        this.minIndex = 0;
        this.maxLen = 0;
        this.minNodesForMaxLen = Integer.MAX_VALUE;
        this.dfs(0, -1);
        return new int[]{this.maxLen, this.minNodesForMaxLen};
    }

    private void buildDist(int u, int parent, int currDist) {
        this.dist[u] = currDist;
        for (int[] edge : this.adj[u]) {
            int v = edge[0];
            int w = edge[1];
            if (v == parent) continue;
            this.buildDist(v, u, currDist + w);
        }
    }

    private void dfs(int u, int parent) {
        int stackPos = this.pathStack.size();
        this.pathStack.add(u);
        int val = this.nums[u];
        int oldPos = this.lastOccur[val];
        int oldMinIndex = this.minIndex;
        this.lastOccur[val] = stackPos;
        if (oldPos >= this.minIndex) {
            this.minIndex = oldPos + 1;
        }
        if (this.minIndex <= stackPos) {
            int ancestor = this.pathStack.get(this.minIndex);
            int pathLength = this.dist[u] - this.dist[ancestor];
            int pathNodes = stackPos - this.minIndex + 1;
            if (pathLength > this.maxLen) {
                this.maxLen = pathLength;
                this.minNodesForMaxLen = pathNodes;
            } else if (pathLength == this.maxLen && pathNodes < this.minNodesForMaxLen) {
                this.minNodesForMaxLen = pathNodes;
            }
        }
        for (int[] edge : this.adj[u]) {
            int v = edge[0];
            if (v == parent) continue;
            this.dfs(v, u);
        }
        this.pathStack.remove(this.pathStack.size() - 1);
        this.lastOccur[val] = oldPos;
        this.minIndex = oldMinIndex;
    }
}

