/*
 * Decompiled with CFR 0.152.
 */
package g3501_3600.s3600_maximize_spanning_tree_stability_with_upgrades;

public class Solution {
    public int maxStability(int n, int[][] edges, int k) {
        int low = 0;
        int high = 0;
        for (int[] edge : edges) {
            high = Math.max(high, edge[2]);
        }
        high *= 2;
        int ans = -1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (this.feasible(mid, n, edges, k)) {
                ans = mid;
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return ans;
    }

    private boolean feasible(int t, int n, int[][] edges, int k) {
        int m;
        int s;
        int v;
        int u;
        int[] par = new int[n];
        int[] rnk = new int[n];
        int[] comp = new int[]{n};
        for (int i = 0; i < n; ++i) {
            par[i] = i;
        }
        UnionFind uf = new UnionFind(par, rnk, comp);
        int cost = 0;
        int half = (t + 1) / 2;
        for (int[] edge : edges) {
            u = edge[0];
            v = edge[1];
            s = edge[2];
            m = edge[3];
            if (m != 1 || s >= t && uf.union(u, v)) continue;
            return false;
        }
        for (int[] edge : edges) {
            u = edge[0];
            v = edge[1];
            s = edge[2];
            m = edge[3];
            if (m != 0 || s < t) continue;
            uf.union(u, v);
        }
        if (comp[0] == 1) {
            return true;
        }
        for (int[] edge : edges) {
            u = edge[0];
            v = edge[1];
            s = edge[2];
            m = edge[3];
            if (m != 0 || s < half || s >= t || !uf.union(u, v) || ++cost <= k) continue;
            return false;
        }
        return comp[0] == 1;
    }

    private static class UnionFind {
        int[] par;
        int[] rnk;
        int[] comp;

        UnionFind(int[] par, int[] rnk, int[] comp) {
            this.par = par;
            this.rnk = rnk;
            this.comp = comp;
        }

        int find(int x) {
            if (this.par[x] != x) {
                this.par[x] = this.find(this.par[x]);
            }
            return this.par[x];
        }

        boolean union(int a, int b) {
            int rb;
            int ra = this.find(a);
            if (ra == (rb = this.find(b))) {
                return false;
            }
            if (this.rnk[ra] < this.rnk[rb]) {
                int temp = ra;
                ra = rb;
                rb = temp;
            }
            this.par[rb] = ra;
            if (this.rnk[ra] == this.rnk[rb]) {
                int n = ra;
                this.rnk[n] = this.rnk[n] + 1;
            }
            this.comp[0] = this.comp[0] - 1;
            return true;
        }
    }
}

