/*
 * Decompiled with CFR 0.152.
 */
package g3601_3700.s3625_count_number_of_trapezoids_ii;

import java.util.HashMap;
import java.util.Map;

public class Solution {
    public int countTrapezoids(int[][] points) {
        int n = points.length;
        HashMap<Slope, Map> slopeLines = new HashMap<Slope, Map>();
        HashMap<Pair, Map> midpointSlopes = new HashMap<Pair, Map>();
        for (int i = 0; i < n; ++i) {
            int x1 = points[i][0];
            int y1 = points[i][1];
            for (int j = i + 1; j < n; ++j) {
                int x2 = points[j][0];
                int y2 = points[j][1];
                int dx = x2 - x1;
                int dy = y2 - y1;
                int g = this.gcd(Math.abs(dx), Math.abs(dy));
                if ((dx /= g) < 0 || dx == 0 && (dy /= g) < 0) {
                    dx = -dx;
                    dy = -dy;
                }
                int nx = -dy;
                int ny = dx;
                long lineId = (long)nx * (long)x1 + (long)ny * (long)y1;
                Slope slopeKey = new Slope(dx, dy);
                slopeLines.computeIfAbsent(slopeKey, k -> new HashMap()).merge(lineId, 1, Integer::sum);
                int mx = x1 + x2;
                int my = y1 + y2;
                Pair mid = new Pair(mx, my);
                midpointSlopes.computeIfAbsent(mid, k -> new HashMap()).merge(slopeKey, 1, Integer::sum);
            }
        }
        long trapezoidsRaw = 0L;
        for (Map lines : slopeLines.values()) {
            if (lines.size() < 2) continue;
            long s = 0L;
            long s2 = 0L;
            for (Integer line : lines.values()) {
                s += (long)line.intValue();
                s2 += (long)line.intValue() * (long)line.intValue();
            }
            trapezoidsRaw += (s * s - s2) / 2L;
        }
        long parallelograms = 0L;
        for (Map mp : midpointSlopes.values()) {
            if (mp.size() < 2) continue;
            long s = 0L;
            long s2 = 0L;
            for (Integer num : mp.values()) {
                s += (long)num.intValue();
                s2 += (long)num.intValue() * (long)num.intValue();
            }
            parallelograms += (s * s - s2) / 2L;
        }
        long res = trapezoidsRaw - parallelograms;
        return res > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)res;
    }

    private int gcd(int a, int b) {
        while (b != 0) {
            int t = a % b;
            a = b;
            b = t;
        }
        return a == 0 ? 1 : a;
    }

    private static class Slope {
        int dx;
        int dy;

        Slope(int dx, int dy) {
            this.dx = dx;
            this.dy = dy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Slope)) {
                return false;
            }
            Slope s = (Slope)o;
            return this.dx == s.dx && this.dy == s.dy;
        }

        public int hashCode() {
            return this.dx * 1000003 ^ this.dy;
        }
    }

    private static class Pair {
        int a;
        int b;

        Pair(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair p = (Pair)o;
            return this.a == p.a && this.b == p.b;
        }

        public int hashCode() {
            return this.a * 1000003 ^ this.b;
        }
    }
}

