/*
 * Decompiled with CFR 0.152.
 */
package g1901_2000.s1993_operations_on_tree;

import java.util.ArrayList;
import java.util.List;

public class LockingTree {
    private List<Integer>[] graph;
    private boolean[] locked;
    private int[] parent;
    private int[] users;
    private int[] control;

    public LockingTree(int[] parent) {
        int i;
        int n = parent.length;
        this.parent = parent;
        this.graph = new ArrayList[n];
        for (i = 0; i < n; ++i) {
            this.graph[i] = new ArrayList<Integer>();
        }
        for (i = 1; i < n; ++i) {
            this.graph[parent[i]].add(i);
        }
        this.locked = new boolean[n];
        this.users = new int[n];
        this.control = new int[n];
    }

    private void setLock(int id, int user) {
        this.locked[id] = true;
        this.users[id] = user;
    }

    private void subNodeUnlock(int id) {
        for (int child : this.graph[id]) {
            this.locked[child] = false;
            if (this.control[child] <= 0) continue;
            this.control[child] = 0;
            this.subNodeUnlock(child);
        }
    }

    public boolean lock(int id, int user) {
        if (this.locked[id]) {
            return false;
        }
        this.setLock(id, user);
        if (this.control[id] == 0) {
            int node = this.parent[id];
            while (node != -1) {
                int n = node;
                this.control[n] = this.control[n] + 1;
                if (this.locked[node] || this.control[node] > 1) break;
                node = this.parent[node];
            }
        }
        return true;
    }

    public boolean unlock(int id, int user) {
        if (!this.locked[id] || this.users[id] != user) {
            return false;
        }
        this.locked[id] = false;
        if (this.control[id] == 0) {
            int node = this.parent[id];
            while (node != -1) {
                int n = node;
                this.control[n] = this.control[n] - 1;
                if (this.locked[node] || this.control[node] >= 1) break;
                node = this.parent[node];
            }
        }
        return true;
    }

    public boolean upgrade(int id, int user) {
        if (this.locked[id] || this.control[id] == 0) {
            return false;
        }
        int cur = this.parent[id];
        while (cur != -1) {
            if (this.locked[cur]) {
                return false;
            }
            cur = this.parent[cur];
        }
        this.setLock(id, user);
        if (this.control[id] > 0) {
            this.control[id] = 0;
            this.subNodeUnlock(id);
        }
        return true;
    }
}

