/*
 * Decompiled with CFR 0.152.
 */
package g3501_3600.s3547_maximum_sum_of_edge_values_in_a_graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Solution {
    private int[] p;
    private boolean[] c;
    private int[] s;

    public long maxScore(int n, int[][] edges) {
        this.initializeArrays(n);
        this.processEdges(edges);
        ArrayList<Integer> circles = new ArrayList<Integer>();
        ArrayList<Integer> chains = new ArrayList<Integer>();
        this.findParentsAndUpdateCircles();
        this.collectCirclesAndChains(circles, chains);
        Collections.sort(circles);
        chains.sort((a, b) -> Integer.compare(b, a));
        return this.calculateScore(n, circles, chains);
    }

    private void initializeArrays(int n) {
        this.p = new int[n];
        this.c = new boolean[n];
        this.s = new int[n];
        for (int i = 0; i < n; ++i) {
            this.p[i] = i;
            this.s[i] = 1;
        }
    }

    private void processEdges(int[][] edges) {
        for (int[] ele : edges) {
            this.join(ele[0], ele[1]);
        }
    }

    private void findParentsAndUpdateCircles() {
        for (int i = 0; i < this.p.length; ++i) {
            this.p[i] = this.findParent(i);
            if (!this.c[i]) continue;
            this.c[this.p[i]] = true;
        }
    }

    private void collectCirclesAndChains(List<Integer> circles, List<Integer> chains) {
        for (int i = 0; i < this.p.length; ++i) {
            if (this.p[i] != i) continue;
            int size = this.s[i];
            if (this.c[i]) {
                circles.add(size);
                continue;
            }
            chains.add(size);
        }
    }

    private long calculateScore(int n, List<Integer> circles, List<Integer> chains) {
        long ret = 0L;
        int start = n;
        ret += this.processCircles(circles, start);
        start = n - this.getTotalCircleSize(circles);
        return ret += this.processChains(chains, start);
    }

    private int getTotalCircleSize(List<Integer> circles) {
        return circles.stream().mapToInt(Integer::intValue).sum();
    }

    private long processCircles(List<Integer> circles, int start) {
        long ret = 0L;
        for (int size : circles) {
            if (size == 1) continue;
            int[] temp = this.createTempArray(size, start);
            long pro = this.calculateProduct(temp, true);
            ret += pro;
            start -= size;
        }
        return ret;
    }

    private long processChains(List<Integer> chains, int start) {
        long ret = 0L;
        for (int size : chains) {
            if (size == 1) continue;
            int[] temp = this.createTempArray(size, start);
            long pro = this.calculateProduct(temp, false);
            ret += pro;
            start -= size;
        }
        return ret;
    }

    private int[] createTempArray(int size, int start) {
        int[] temp = new int[size];
        int ptr1 = 0;
        int ptr2 = size - 1;
        int curStart = start - size + 1;
        for (int i = 0; i < size; ++i) {
            if (i % 2 == 0) {
                temp[ptr1++] = curStart + i;
                continue;
            }
            temp[ptr2--] = curStart + i;
        }
        return temp;
    }

    private long calculateProduct(int[] temp, boolean isCircle) {
        long pro = 0L;
        for (int i = 1; i < temp.length; ++i) {
            pro += (long)temp[i] * (long)temp[i - 1];
        }
        if (isCircle) {
            pro += (long)temp[0] * (long)temp[temp.length - 1];
        }
        return pro;
    }

    private int findParent(int x) {
        if (this.p[x] != x) {
            this.p[x] = this.findParent(this.p[x]);
        }
        return this.p[x];
    }

    private void join(int a, int b) {
        int ap;
        int bp = this.findParent(a);
        if (bp == (ap = this.findParent(b))) {
            this.c[bp] = true;
            return;
        }
        int s1 = this.s[ap];
        int s2 = this.s[bp];
        if (s1 > s2) {
            this.p[bp] = ap;
            int n = ap;
            this.s[n] = this.s[n] + this.s[bp];
        } else {
            this.p[ap] = bp;
            int n = bp;
            this.s[n] = this.s[n] + this.s[ap];
        }
    }
}

