/*
 * Decompiled with CFR 0.152.
 */
package g3601_3700.s3669_balanced_k_factor_decomposition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Solution {
    private int kGlobal;
    private int bestDiff = Integer.MAX_VALUE;
    private List<Integer> bestList = new ArrayList<Integer>();
    private final List<Integer> current = new ArrayList<Integer>();

    public int[] minDifference(int n, int k) {
        this.kGlobal = k;
        this.dfs(n, 1, 0);
        int[] ans = new int[this.bestList.size()];
        for (int i = 0; i < this.bestList.size(); ++i) {
            ans[i] = this.bestList.get(i);
        }
        return ans;
    }

    private void dfs(int rem, int start, int depth) {
        if (depth == this.kGlobal - 1) {
            if (rem >= start) {
                this.current.add(rem);
                this.evaluate();
                this.current.remove(this.current.size() - 1);
            }
            return;
        }
        List<Integer> divs = this.getDivisors(rem);
        for (int d : divs) {
            if (d < start) continue;
            this.current.add(d);
            this.dfs(rem / d, d, depth + 1);
            this.current.remove(this.current.size() - 1);
        }
    }

    private void evaluate() {
        int mn = Integer.MAX_VALUE;
        int mx = Integer.MIN_VALUE;
        for (int v : this.current) {
            mn = Math.min(mn, v);
            mx = Math.max(mx, v);
        }
        int diff = mx - mn;
        if (diff < this.bestDiff) {
            this.bestDiff = diff;
            this.bestList = new ArrayList<Integer>(this.current);
        }
    }

    private List<Integer> getDivisors(int x) {
        ArrayList<Integer> small = new ArrayList<Integer>();
        ArrayList<Integer> large = new ArrayList<Integer>();
        int i = 1;
        while ((long)i * (long)i <= (long)x) {
            if (x % i == 0) {
                small.add(i);
                if (i != x / i) {
                    large.add(x / i);
                }
            }
            ++i;
        }
        Collections.reverse(large);
        small.addAll(large);
        return small;
    }
}

