/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.infra;

import com.github.jbgust.jsrm.application.JSRMConfig;
import com.github.jbgust.jsrm.application.RegisteredPropellant;
import com.github.jbgust.jsrm.application.motor.SolidRocketMotor;
import com.github.jbgust.jsrm.application.motor.propellant.PropellantGrain;
import com.github.jbgust.jsrm.application.motor.propellant.SolidPropellant;
import com.github.jbgust.jsrm.infra.JSRMConstant;
import com.github.jbgust.jsrm.infra.function.CircleAreaFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.objecthunter.exp4j.ExpressionBuilder;

public class ConstantsExtractor {
    public static Map<JSRMConstant, Double> extract(SolidRocketMotor solidRocketMotor, JSRMConfig config) {
        PropellantGrain propellantGrain = solidRocketMotor.getPropellantGrain();
        double twoValue = (propellantGrain.getOuterDiameter() - propellantGrain.getCoreDiameter()) / 2.0;
        SolidPropellant propellant = propellantGrain.getPropellant();
        HashMap<JSRMConstant, Double> constants = new HashMap<JSRMConstant, Double>();
        constants.put(JSRMConstant.ci, Double.valueOf(propellantGrain.getCoreSurface().value()));
        constants.put(JSRMConstant.osi, Double.valueOf(propellantGrain.getOuterSurface().value()));
        constants.put(JSRMConstant.ei, Double.valueOf(propellantGrain.getEndsSurface().value()));
        constants.put(JSRMConstant.xincp, twoValue / 834.0 / (double)ConstantsExtractor.getXincFactor(propellantGrain));
        constants.put(JSRMConstant.dc, solidRocketMotor.getCombustionChamber().getChamberInnerDiameterInMillimeter());
        constants.put(JSRMConstant.n, propellantGrain.getNumberOfSegment());
        constants.put(JSRMConstant.vc, solidRocketMotor.getCombustionChamber().getVolume());
        constants.put(JSRMConstant.dto, solidRocketMotor.getThroatDiameterInMillimeter());
        constants.put(JSRMConstant.two, twoValue);
        constants.put(JSRMConstant.at, new CircleAreaFunction().runFunction(solidRocketMotor.getThroatDiameterInMillimeter()));
        constants.put(JSRMConstant.erate, config.getNozzleErosionInMillimeter());
        constants.put(JSRMConstant.gstar, config.getErosiveBurningAreaRatioThreshold());
        constants.put(JSRMConstant.kv, config.getErosiveBurningVelocityCoefficient());
        constants.put(JSRMConstant.to, config.getCombustionEfficiencyRatio() * propellant.getChamberTemperature());
        constants.put(JSRMConstant.patm, config.getAmbiantPressureInMPa());
        constants.put(JSRMConstant.rhopgrain, config.getDensityRatio() * propellant.getIdealMassDensity());
        constants.put(JSRMConstant.etanoz, config.getNozzleEfficiency());
        constants.put(JSRMConstant.pbd, 0.0);
        constants.put(JSRMConstant.rat, 8314.0 / propellant.getEffectiveMolecularWeight());
        constants.put(JSRMConstant.k, propellant.getK());
        constants.put(JSRMConstant.propellantId, Double.valueOf(RegisteredPropellant.registerPropellant(propellant).intValue()));
        constants.put(JSRMConstant.cstar, ConstantsExtractor.computeCstarValue(constants));
        constants.put(JSRMConstant.k2ph, propellant.getK2Ph());
        constants.put(JSRMConstant.mgrain, ConstantsExtractor.computeGrainMass(constants.get((Object)JSRMConstant.rhopgrain), propellantGrain));
        return constants;
    }

    private static int getXincFactor(PropellantGrain propellantGrain) {
        return propellantGrain.getCoreSurface().value() + propellantGrain.getOuterSurface().value();
    }

    private static double computeGrainMass(Double rhopgrain, PropellantGrain propellantGrain) {
        return new ExpressionBuilder("pi/4*(do^2-dio^2)*lgo").variables(new String[]{"do", "dio", "lgo"}).build().setVariable("do", propellantGrain.getOuterDiameter()).setVariable("dio", propellantGrain.getCoreDiameter()).setVariable("lgo", propellantGrain.getGrainLength()).evaluate() * rhopgrain / 1000.0 / 1000.0;
    }

    private static double computeCstarValue(HashMap<JSRMConstant, Double> constants) {
        return new ExpressionBuilder("sqrt(rat*to/k*((k+1)/2)^((k+1)/(k-1)))").variables(new String[]{JSRMConstant.rat.name(), JSRMConstant.to.name(), JSRMConstant.k.name()}).build().setVariables(ConstantsExtractor.toCalculationFormat(constants)).evaluate();
    }

    public static Map<String, Double> toCalculationFormat(Map<JSRMConstant, Double> jsrmConstantDoubleMap) {
        return jsrmConstantDoubleMap.entrySet().stream().collect(Collectors.toMap(entry -> ((JSRMConstant)((Object)((Object)entry.getKey()))).name(), Map.Entry::getValue));
    }
}

