/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.infra.pressure;

import com.github.jbgust.jsrm.application.JSRMConfig;
import com.github.jbgust.jsrm.application.motor.SolidRocketMotor;
import com.github.jbgust.jsrm.calculation.CalculatorBuilder;
import com.github.jbgust.jsrm.calculation.CalculatorResults;
import com.github.jbgust.jsrm.calculation.Formula;
import com.github.jbgust.jsrm.infra.ConstantsExtractor;
import com.github.jbgust.jsrm.infra.JSRMConstant;
import com.github.jbgust.jsrm.infra.pressure.IncrementTimeBurstSolver;
import com.github.jbgust.jsrm.infra.pressure.PostBurnPressureFormulas;
import com.github.jbgust.jsrm.infra.pressure.PressureFormulas;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ChamberPressureCalculation {
    private final Map<JSRMConstant, Double> constants;
    private final Map<Formula, Double> initialValues;

    public ChamberPressureCalculation(SolidRocketMotor motor, JSRMConfig config, Map<JSRMConstant, Double> constants) {
        this.constants = constants;
        this.initialValues = this.getInitialValues(motor, config);
    }

    public Map<Results, List<Double>> compute() {
        CalculatorResults pressureResults = this.computeChamberPressureDuringPropellantBurn();
        this.addNewConstantsFromPressureResults(pressureResults);
        CalculatorResults postBurnPressureResults = this.computePostBurnPressure();
        return this.buildResults(pressureResults, postBurnPressureResults);
    }

    private Map<Results, List<Double>> buildResults(CalculatorResults pressureResults, CalculatorResults postBurnPressureResults) {
        int lastPressureResultsLine = 834;
        ArrayList<Double> throatAreaResults = new ArrayList<Double>(pressureResults.getResults(PressureFormulas.THROAT_AREA));
        IntStream.range(0, 48).forEach(value -> throatAreaResults.add(pressureResults.getResult(PressureFormulas.THROAT_AREA, lastPressureResultsLine)));
        ArrayList<Double> nozzlePassageAreaResults = new ArrayList<Double>(pressureResults.getResults(PressureFormulas.NOZZLE_CRITICAL_PASSAGE_AREA));
        IntStream.range(0, 48).forEach(value -> nozzlePassageAreaResults.add(pressureResults.getResult(PressureFormulas.NOZZLE_CRITICAL_PASSAGE_AREA, lastPressureResultsLine)));
        List<Double> timeSinceBurnStartResults = this.mergeResults(pressureResults, postBurnPressureResults, PressureFormulas.TIME_SINCE_BURN_STARTS, PostBurnPressureFormulas.POST_BURN_TIME_SINCE_BURN_STARTS);
        List<Double> chamberPressureMPAResults = this.mergeResults(pressureResults, postBurnPressureResults, PressureFormulas.CHAMBER_PRESSURE_MPA, PostBurnPressureFormulas.POST_BURN_CHAMBER_PRESSURE_MPA);
        List<Double> absoluteChamberPressureResults = this.mergeResults(pressureResults, postBurnPressureResults, PressureFormulas.ABSOLUTE_CHAMBER_PRESSURE, PostBurnPressureFormulas.POST_BURN_ABSOLUTE_CHAMBER_PRESSURE);
        List<Double> absoluteChamberPressurePSIGResults = this.mergeResults(pressureResults, postBurnPressureResults, PressureFormulas.ABSOLUTE_CHAMBER_PRESSURE_PSIG, PostBurnPressureFormulas.POST_BURN_ABSOLUTE_CHAMBER_PRESSURE_PSIG);
        timeSinceBurnStartResults.add(this.constants.get((Object)JSRMConstant.tbinc) + timeSinceBurnStartResults.get(timeSinceBurnStartResults.size() - 1));
        chamberPressureMPAResults.add(0.0);
        absoluteChamberPressureResults.add(0.0);
        absoluteChamberPressurePSIGResults.add(0.0);
        return ImmutableMap.builder().put((Object)Results.throatArea, throatAreaResults).put((Object)Results.nozzleCriticalPassageArea, nozzlePassageAreaResults).put((Object)Results.timeSinceBurnStart, timeSinceBurnStartResults).put((Object)Results.chamberPressureMPA, chamberPressureMPAResults).put((Object)Results.absoluteChamberPressure, absoluteChamberPressureResults).put((Object)Results.absoluteChamberPressurePSIG, absoluteChamberPressurePSIGResults).build();
    }

    private List<Double> mergeResults(CalculatorResults pressureResults, CalculatorResults postBurnPressureResults, PressureFormulas pressureFormulas, PostBurnPressureFormulas postBurnPressureFormulas) {
        return Stream.concat(pressureResults.getResults(pressureFormulas).stream(), postBurnPressureResults.getResults(postBurnPressureFormulas).stream()).collect(Collectors.toList());
    }

    private CalculatorResults computePostBurnPressure() {
        this.initialValues.put(PostBurnPressureFormulas.POST_BURN_TIME_SINCE_BURN_STARTS, this.constants.get((Object)JSRMConstant.tbout) + this.constants.get((Object)JSRMConstant.tbinc));
        return new CalculatorBuilder(PostBurnPressureFormulas.POST_BURN_ABSOLUTE_CHAMBER_PRESSURE_PSIG).withConstants(ConstantsExtractor.toCalculationFormat(this.constants)).withInitialValues(this.initialValues).withResultsToSave(PostBurnPressureFormulas.values()).createCalculator().compute(0, 47);
    }

    private CalculatorResults computeChamberPressureDuringPropellantBurn() {
        return new CalculatorBuilder(PressureFormulas.ABSOLUTE_CHAMBER_PRESSURE_PSIG).withConstants(ConstantsExtractor.toCalculationFormat(this.constants)).withInitialValues(this.initialValues).withResultsToSave(PressureFormulas.THROAT_AREA, PressureFormulas.NOZZLE_CRITICAL_PASSAGE_AREA, PressureFormulas.TIME_SINCE_BURN_STARTS, PressureFormulas.CHAMBER_PRESSURE_MPA, PressureFormulas.ABSOLUTE_CHAMBER_PRESSURE, PressureFormulas.ABSOLUTE_CHAMBER_PRESSURE_PSIG).createCalculator().compute(0, 835);
    }

    private void addNewConstantsFromPressureResults(CalculatorResults pressureResults) {
        int lastPressureResultsLine = 834;
        this.constants.put(JSRMConstant.tbout, pressureResults.getResult(PressureFormulas.TIME_SINCE_BURN_STARTS, lastPressureResultsLine));
        this.constants.put(JSRMConstant.pbout, pressureResults.getResult(PressureFormulas.CHAMBER_PRESSURE_MPA, lastPressureResultsLine));
        this.constants.put(JSRMConstant.astarf, pressureResults.getResult(PressureFormulas.NOZZLE_CRITICAL_PASSAGE_AREA, lastPressureResultsLine));
        this.constants.put(JSRMConstant.expectedPfinal, 2.0 * this.constants.get((Object)JSRMConstant.patm) + 2.0E-4 * this.getPmax(pressureResults));
        this.constants.put(JSRMConstant.tbinc, this.getTbinc(this.constants));
    }

    private double getPmax(CalculatorResults pressureResults) {
        return (Double)pressureResults.getResults(PressureFormulas.ABSOLUTE_CHAMBER_PRESSURE).stream().max(Double::compareTo).get();
    }

    private Double getTbinc(Map<JSRMConstant, Double> constants) {
        Map<String, Double> tbincVariables = Stream.of(JSRMConstant.vc, JSRMConstant.expectedPfinal, JSRMConstant.pbout, JSRMConstant.rat, JSRMConstant.to, JSRMConstant.astarf, JSRMConstant.cstar).collect(Collectors.toMap(Enum::name, constants::get));
        tbincVariables.put("nbLine", 47.0);
        return new IncrementTimeBurstSolver().solve(tbincVariables);
    }

    private Map<Formula, Double> getInitialValues(SolidRocketMotor motor, JSRMConfig config) {
        HashMap<Formula, Double> initialValues = new HashMap<Formula, Double>();
        initialValues.put(PressureFormulas.GRAIN_CORE_DIAMETER, motor.getPropellantGrain().getCoreDiameter());
        initialValues.put(PressureFormulas.GRAIN_OUTSIDE_DIAMETER, motor.getPropellantGrain().getOuterDiameter());
        initialValues.put(PressureFormulas.GRAIN_LENGTH, motor.getPropellantGrain().getGrainLength());
        initialValues.put(PressureFormulas.TEMPORARY_CHAMBER_PRESSURE, config.getAmbiantPressureInMPa());
        initialValues.put(PressureFormulas.TIME_SINCE_BURN_STARTS, 0.0);
        initialValues.put(PressureFormulas.MASS_GENERATION_RATE, 0.0);
        initialValues.put(PressureFormulas.NOZZLE_MASS_FLOW_RATE, 0.0);
        initialValues.put(PressureFormulas.MASS_STORAGE_RATE, 0.0);
        initialValues.put(PressureFormulas.MASS_COMBUSTION_PRODUCTS, 0.0);
        initialValues.put(PressureFormulas.DENSITY_COMBUSTION_PRODUCTS, 0.0);
        return initialValues;
    }

    public static enum Results {
        throatArea,
        nozzleCriticalPassageArea,
        timeSinceBurnStart,
        chamberPressureMPA,
        absoluteChamberPressure,
        absoluteChamberPressurePSIG;

    }
}

