/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application;

import com.github.jbgust.jsrm.application.JSRMConfig;
import com.github.jbgust.jsrm.application.JSRMConfigBuilder;
import com.github.jbgust.jsrm.application.exception.SimulationFailedException;
import com.github.jbgust.jsrm.application.motor.SolidRocketMotor;
import com.github.jbgust.jsrm.application.result.JSRMResult;
import com.github.jbgust.jsrm.application.result.MotorClassification;
import com.github.jbgust.jsrm.application.result.MotorParameters;
import com.github.jbgust.jsrm.application.result.Nozzle;
import com.github.jbgust.jsrm.infra.ConstantsExtractor;
import com.github.jbgust.jsrm.infra.JSRMConstant;
import com.github.jbgust.jsrm.infra.SolidRocketMotorChecker;
import com.github.jbgust.jsrm.infra.performance.PerformanceCalculation;
import com.github.jbgust.jsrm.infra.performance.PerformanceCalculationResult;
import com.github.jbgust.jsrm.infra.performance.PerformanceResultProvider;
import com.github.jbgust.jsrm.infra.pressure.ChamberPressureCalculation;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JSRMSimulation {
    private final SolidRocketMotor motor;
    private JSRMConfig config;

    public JSRMSimulation(SolidRocketMotor motor) {
        SolidRocketMotorChecker.check(motor);
        this.motor = motor;
        this.config = new JSRMConfigBuilder().createJSRMConfig();
    }

    public JSRMResult run() {
        return this.run(this.config);
    }

    public JSRMResult run(JSRMConfig config) {
        try {
            Map<JSRMConstant, Double> constants = ConstantsExtractor.extract(this.motor, new JSRMConfigBuilder().createJSRMConfig());
            Map<ChamberPressureCalculation.Results, List<Double>> chamberPressureResults = new ChamberPressureCalculation(this.motor, config, constants).compute();
            PerformanceResultProvider chamberPressureProvider = new PerformanceResultProvider(ChamberPressureCalculation.Results.chamberPressureMPA, chamberPressureResults.get((Object)ChamberPressureCalculation.Results.chamberPressureMPA));
            PerformanceResultProvider throatAreaProvider = new PerformanceResultProvider(ChamberPressureCalculation.Results.throatArea, chamberPressureResults.get((Object)ChamberPressureCalculation.Results.throatArea));
            PerformanceResultProvider nozzleCriticalPassageAreaProvider = new PerformanceResultProvider(ChamberPressureCalculation.Results.nozzleCriticalPassageArea, chamberPressureResults.get((Object)ChamberPressureCalculation.Results.nozzleCriticalPassageArea));
            PerformanceResultProvider timeSinceBurnStartProvider = new PerformanceResultProvider(ChamberPressureCalculation.Results.timeSinceBurnStart, chamberPressureResults.get((Object)ChamberPressureCalculation.Results.timeSinceBurnStart));
            ImmutableMap performanceConstants = ImmutableMap.builder().putAll(constants).put((Object)JSRMConstant.atfinal, (Object)throatAreaProvider.getResult((int)(throatAreaProvider.getSize() - 1.0))).build();
            PerformanceCalculationResult performanceCalculationResult = new PerformanceCalculation(this.motor, (Map<JSRMConstant, Double>)performanceConstants, chamberPressureProvider, throatAreaProvider, nozzleCriticalPassageAreaProvider, timeSinceBurnStartProvider).compute(config);
            return this.buildResult(config, constants, chamberPressureResults, timeSinceBurnStartProvider, performanceCalculationResult);
        }
        catch (Exception e) {
            throw new SimulationFailedException(e);
        }
    }

    private JSRMResult buildResult(JSRMConfig config, Map<JSRMConstant, Double> constants, Map<ChamberPressureCalculation.Results, List<Double>> chamberPressureResults, PerformanceResultProvider timeSinceBurnStartProvider, PerformanceCalculationResult performanceCalculationResult) {
        double maxThrust = performanceCalculationResult.getResults().get((Object)PerformanceCalculation.Results.thrust).stream().mapToDouble(Double::doubleValue).max().getAsDouble();
        double maxChamberPressure = chamberPressureResults.get((Object)ChamberPressureCalculation.Results.absoluteChamberPressure).stream().mapToDouble(Double::doubleValue).max().getAsDouble();
        double averageChamberPressure = chamberPressureResults.get((Object)ChamberPressureCalculation.Results.absoluteChamberPressure).stream().mapToDouble(Double::doubleValue).average().getAsDouble();
        double totalImpulse = performanceCalculationResult.getResults().get((Object)PerformanceCalculation.Results.deliveredImpulse).stream().mapToDouble(Double::doubleValue).sum();
        double thrustTime = this.getThrustTime(timeSinceBurnStartProvider);
        long averageThrust = Math.round(totalImpulse / thrustTime);
        double specificImpulse = this.getSpecificImpulse(constants, totalImpulse);
        return new JSRMResult(maxThrust, totalImpulse, specificImpulse, maxChamberPressure, averageChamberPressure, thrustTime, MotorClassification.getMotorClassification(totalImpulse), this.buildMotorParametersResult(timeSinceBurnStartProvider, chamberPressureResults, performanceCalculationResult), this.buildNozzleResult(config, performanceCalculationResult), averageThrust);
    }

    private Nozzle buildNozzleResult(JSRMConfig config, PerformanceCalculationResult performanceCalculationResult) {
        return new Nozzle(this.motor.getThroatDiameterInMillimeter(), this.motor.getCombustionChamber().getChamberInnerDiameterInMillimeter(), performanceCalculationResult.getOptimalNozzleExpansionResult(), performanceCalculationResult.getOptimalNozzleExitDiameterInMillimeter(), this.getNozzleExpansionRatioResult(config, performanceCalculationResult), performanceCalculationResult.getNozzleExitDiameterInMillimeter(), performanceCalculationResult.getInitialNozzleExitSpeedInMach(), performanceCalculationResult.getFinalNozzleExitSpeedInMach());
    }

    private List<MotorParameters> buildMotorParametersResult(PerformanceResultProvider timeSinceBurnStartProvider, Map<ChamberPressureCalculation.Results, List<Double>> chamberPressureResults, PerformanceCalculationResult performanceCalculationResult) {
        ArrayList<MotorParameters> motorParameters = new ArrayList<MotorParameters>();
        for (int i = 0; i < 883; ++i) {
            motorParameters.add(new MotorParameters(timeSinceBurnStartProvider.getResult(i), performanceCalculationResult.getResults().get((Object)PerformanceCalculation.Results.thrust).get(i), chamberPressureResults.get((Object)ChamberPressureCalculation.Results.kn).get(i), chamberPressureResults.get((Object)ChamberPressureCalculation.Results.absoluteChamberPressure).get(i), chamberPressureResults.get((Object)ChamberPressureCalculation.Results.massFlowRate).get(i)));
        }
        return motorParameters;
    }

    private double getSpecificImpulse(Map<JSRMConstant, Double> constants, double totalImpulse) {
        return totalImpulse / 9.806 / constants.get((Object)JSRMConstant.mgrain);
    }

    private double getNozzleExpansionRatioResult(JSRMConfig config, PerformanceCalculationResult performanceCalculationResult) {
        return config.isOptimalNozzleDesign() ? performanceCalculationResult.getOptimalNozzleExpansionResult() : config.getNozzleExpansionRatio().doubleValue();
    }

    private double getThrustTime(PerformanceResultProvider timeSinceBurnStartProvider) {
        return timeSinceBurnStartProvider.getResult((int)(timeSinceBurnStartProvider.getSize() - 2.0));
    }
}

