/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application;

import com.github.jbgust.jsrm.application.JSRMConfig;
import com.github.jbgust.jsrm.application.exception.InvalidConfigurationException;

public class JSRMConfigBuilder {
    private double densityRatio = 0.95;
    private double nozzleErosionInMillimeter = 0.0;
    private double combustionEfficiencyRatio = 0.95;
    private double ambiantPressureInMPa = 0.101;
    private double erosiveBurningAreaRatioThreshold = 6.0;
    private double erosiveBurningVelocityCoefficient = 0.0;
    private double nozzleEfficiency = 0.85;
    private boolean optimalNozzleDesign = true;
    private Double nozzleExpansionRatio = null;
    private int numberLineDuringBurnCalculation = 835;
    private int numberLineDuringPostBurnCalculation = 47;

    public JSRMConfigBuilder withDensityRatio(double densityRatio) {
        this.densityRatio = densityRatio;
        return this;
    }

    public JSRMConfigBuilder withNozzleErosionInMillimeter(double nozzleErosionInMillimeter) {
        this.nozzleErosionInMillimeter = nozzleErosionInMillimeter;
        return this;
    }

    public JSRMConfigBuilder withCombustionEfficiencyRatio(double combustionEfficiencyRatio) {
        this.combustionEfficiencyRatio = combustionEfficiencyRatio;
        return this;
    }

    public JSRMConfigBuilder withAmbiantPressureInMPa(double ambiantPressureInMPa) {
        this.ambiantPressureInMPa = ambiantPressureInMPa;
        return this;
    }

    public JSRMConfigBuilder withErosiveBurningAreaRatioThreshold(double erosiveBurningAreaRatioThreshold) {
        this.erosiveBurningAreaRatioThreshold = erosiveBurningAreaRatioThreshold;
        return this;
    }

    public JSRMConfigBuilder withErosiveBurningVelocityCoefficient(double erosiveBurningVelocityCoefficient) {
        this.erosiveBurningVelocityCoefficient = erosiveBurningVelocityCoefficient;
        return this;
    }

    public JSRMConfigBuilder withNozzleEfficiency(double nozzleEfficiency) {
        this.nozzleEfficiency = nozzleEfficiency;
        return this;
    }

    public JSRMConfigBuilder withOptimalNozzleDesign(boolean optimalNozzleDesign) {
        this.optimalNozzleDesign = optimalNozzleDesign;
        return this;
    }

    public JSRMConfigBuilder withNumberOfCalculationLine(int numberOfCalculationLine) {
        this.numberLineDuringBurnCalculation = (int)((double)numberOfCalculationLine * 0.96);
        this.numberLineDuringPostBurnCalculation = numberOfCalculationLine - this.numberLineDuringBurnCalculation - 1;
        return this;
    }

    public JSRMConfigBuilder withNozzleExpansionRatio(double nozzleExpansionRatio) {
        this.nozzleExpansionRatio = nozzleExpansionRatio;
        this.optimalNozzleDesign = false;
        return this;
    }

    public JSRMConfig createJSRMConfig() {
        if (!this.optimalNozzleDesign && this.nozzleExpansionRatio == null) {
            throw new InvalidConfigurationException("Your configuration should defined a nozzleExpansionRatio if you don't use optimalNozzleDesign");
        }
        if (this.optimalNozzleDesign && this.nozzleExpansionRatio != null) {
            throw new InvalidConfigurationException("Your configuration should not use both optimalNozzleDesign and nozzleExpansionRatio");
        }
        return new JSRMConfig(this.densityRatio, this.nozzleErosionInMillimeter, this.combustionEfficiencyRatio, this.ambiantPressureInMPa, this.erosiveBurningAreaRatioThreshold, this.erosiveBurningVelocityCoefficient, this.nozzleEfficiency, this.optimalNozzleDesign, this.nozzleExpansionRatio, this.numberLineDuringBurnCalculation, this.numberLineDuringPostBurnCalculation);
    }
}

