/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.propellant;

import com.github.jbgust.jsrm.application.motor.propellant.GrainSurface;
import com.github.jbgust.jsrm.application.motor.propellant.SolidPropellant;
import net.objecthunter.exp4j.ExpressionBuilder;

public class PropellantGrain {
    private final SolidPropellant propellant;
    private final double outerDiameter;
    private final double coreDiameter;
    private final double segmentLength;
    private final double numberOfSegment;
    private final GrainSurface outerSurface;
    private final GrainSurface endsSurface;
    private final GrainSurface coreSurface;

    public PropellantGrain(SolidPropellant propellant, double outerDiameter, double coreDiameter, double segmentLength, double numberOfSegment, GrainSurface outerSurface, GrainSurface endsSurface, GrainSurface coreSurface) {
        this.propellant = propellant;
        this.outerDiameter = outerDiameter;
        this.coreDiameter = coreDiameter;
        this.segmentLength = segmentLength;
        this.numberOfSegment = numberOfSegment;
        this.outerSurface = outerSurface;
        this.endsSurface = endsSurface;
        this.coreSurface = coreSurface;
    }

    public double getGrainVolume() {
        return new ExpressionBuilder("pi * (outerRadius^2 - coreRadius^2) * grainLength").variables(new String[]{"outerRadius", "coreRadius", "grainLength"}).build().setVariable("outerRadius", this.outerDiameter / 2.0).setVariable("coreRadius", this.coreDiameter / 2.0).setVariable("grainLength", this.getGrainLength()).evaluate();
    }

    public double getGrainLength() {
        return this.numberOfSegment * this.segmentLength;
    }

    public double getInitialWebThickness() {
        return (this.outerDiameter - this.coreDiameter) / 2.0;
    }

    public SolidPropellant getPropellant() {
        return this.propellant;
    }

    public double getOuterDiameter() {
        return this.outerDiameter;
    }

    public double getCoreDiameter() {
        return this.coreDiameter;
    }

    public double getSegmentLength() {
        return this.segmentLength;
    }

    public double getNumberOfSegment() {
        return this.numberOfSegment;
    }

    public GrainSurface getOuterSurface() {
        return this.outerSurface;
    }

    public GrainSurface getEndsSurface() {
        return this.endsSurface;
    }

    public GrainSurface getCoreSurface() {
        return this.coreSurface;
    }
}

