/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.infra.pressure;

import com.github.jbgust.jsrm.calculation.Formula;
import com.github.jbgust.jsrm.infra.FormulaConfiguration;
import com.github.jbgust.jsrm.infra.JSRMConstant;
import com.github.jbgust.jsrm.infra.function.CircleAreaFunction;
import com.github.jbgust.jsrm.infra.function.HollowCircleAreaFunction;
import com.github.jbgust.jsrm.infra.pressure.function.BurnRateCharacteristicFunction;
import com.github.jbgust.jsrm.infra.pressure.function.ErosiveBurnFactorFunction;
import com.github.jbgust.jsrm.infra.pressure.function.FreeVolumeInChamberFunction;
import com.github.jbgust.jsrm.infra.pressure.function.GrainMassFunction;
import com.github.jbgust.jsrm.infra.pressure.function.LowKnFunction;
import com.github.jbgust.jsrm.infra.pressure.function.NozzleMassFlowRateFunction;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public enum PressureFormulas implements Formula
{
    GRAIN_CORE_DIAMETER(new FormulaConfiguration("GRAIN_CORE_DIAMETER_previous + ci * 2 * xincp").withConstants(JSRMConstant.ci, JSRMConstant.xincp).withVariables("GRAIN_CORE_DIAMETER_previous")),
    GRAIN_OUTSIDE_DIAMETER(new FormulaConfiguration("GRAIN_OUTSIDE_DIAMETER_previous - osi * 2 * xincp").withConstants(JSRMConstant.osi, JSRMConstant.xincp).withVariables("GRAIN_OUTSIDE_DIAMETER_previous")),
    GRAIN_LENGTH(new FormulaConfiguration("GRAIN_LENGTH_previous-ei*n*2*xincp").withConstants(JSRMConstant.ei, JSRMConstant.n, JSRMConstant.xincp).withVariables("GRAIN_LENGTH_previous")),
    WEB_THICKNESS(new FormulaConfiguration("(GRAIN_OUTSIDE_DIAMETER - GRAIN_CORE_DIAMETER) / 2").withDependencies("GRAIN_CORE_DIAMETER", "GRAIN_OUTSIDE_DIAMETER")),
    THROAT_AREA(new FormulaConfiguration("CircleArea(dto+erate*(two-WEB_THICKNESS)/two)").withDependencies("WEB_THICKNESS").withConstants(JSRMConstant.dto, JSRMConstant.erate, JSRMConstant.two).withFunctions(Functions.access$000())),
    NOZZLE_CRITICAL_PASSAGE_AREA(new FormulaConfiguration("THROAT_AREA / 1000^2").withDependencies("THROAT_AREA")),
    END_GRAIN_SRUFACE(new FormulaConfiguration("HollowCircleArea(GRAIN_OUTSIDE_DIAMETER, GRAIN_CORE_DIAMETER)").withDependencies("GRAIN_OUTSIDE_DIAMETER", "GRAIN_CORE_DIAMETER").withFunctions(Functions.access$100())),
    EROSIVE_BURN_FACTOR(new FormulaConfiguration("ErosiveBurnFactor((CircleArea(dc)-END_GRAIN_SRUFACE)/THROAT_AREA, gstar)").withDependencies("THROAT_AREA", "END_GRAIN_SRUFACE").withConstants(JSRMConstant.dc, JSRMConstant.gstar).withFunctions(Functions.access$200(), Functions.access$000())),
    GRAIN_END_BURNING_SURFACE(new FormulaConfiguration("(ei * 2 * endGrainSurface) * n").withVariables("endGrainSurface").withConstants(JSRMConstant.n, JSRMConstant.ei)),
    GRAIN_CORE_BURNING_SURFACE(new FormulaConfiguration("ci * pi * grainCoreDiameter * grainLength").withVariables("grainCoreDiameter", "grainLength").withConstants(JSRMConstant.ci)),
    GRAIN_OUTER_BURNING_SURFACE(new FormulaConfiguration("osi * pi * grainOutsideDiameter * grainLength").withVariables("grainOutsideDiameter", "grainLength").withConstants(JSRMConstant.osi)),
    GRAIN_VOLUME(new FormulaConfiguration("(END_GRAIN_SRUFACE * GRAIN_LENGTH)").withDependencies("GRAIN_LENGTH", "END_GRAIN_SRUFACE")),
    TEMPORARY_CHAMBER_PRESSURE(new FormulaConfiguration("CHAMBER_PRESSURE_MPA_previous").withVariables("CHAMBER_PRESSURE_MPA_previous")),
    PROPELLANT_BURN_RATE(new FormulaConfiguration("(1 + kv * EROSIVE_BURN_FACTOR) * BurnRateCharacteristic(propellantId, TEMPORARY_CHAMBER_PRESSURE)").withConstants(JSRMConstant.kv, JSRMConstant.propellantId).withFunctions(Functions.access$300()).withDependencies("EROSIVE_BURN_FACTOR", "TEMPORARY_CHAMBER_PRESSURE")),
    TIME_SINCE_BURN_STARTS(new FormulaConfiguration("xincp / PROPELLANT_BURN_RATE + TIME_SINCE_BURN_STARTS_previous").withConstants(JSRMConstant.xincp).withDependencies("PROPELLANT_BURN_RATE").withVariables("TIME_SINCE_BURN_STARTS_previous")),
    MASS_GENERATION_RATE(new FormulaConfiguration("(GrainMass(rhopgrain, GRAIN_VOLUME_previous)-GrainMass(rhopgrain, GRAIN_VOLUME)) / (TIME_SINCE_BURN_STARTS-TIME_SINCE_BURN_STARTS_previous)").withDependencies("GRAIN_VOLUME", "TIME_SINCE_BURN_STARTS").withVariables("GRAIN_VOLUME_previous", "TIME_SINCE_BURN_STARTS_previous").withConstants(JSRMConstant.rhopgrain).withFunctions(Functions.access$400())),
    NOZZLE_MASS_FLOW_RATE(new FormulaConfiguration("NozzleMassFlowRate(pbd, MASS_GENERATION_RATE, CHAMBER_PRESSURE_MPA_previous, AI)").withConstants(JSRMConstant.pbd).withDependencies("MASS_GENERATION_RATE", "AI").withVariables("CHAMBER_PRESSURE_MPA_previous").withFunctions(Functions.access$500())),
    MASS_STORAGE_RATE(new FormulaConfiguration("lowKn(MASS_GENERATION_RATE - NOZZLE_MASS_FLOW_RATE, safeKN)").withDependencies("MASS_GENERATION_RATE", "NOZZLE_MASS_FLOW_RATE").withConstants(JSRMConstant.safeKN).withFunctions(Functions.access$600())),
    MASS_COMBUSTION_PRODUCTS(new FormulaConfiguration("MASS_STORAGE_RATE * (TIME_SINCE_BURN_STARTS-TIME_SINCE_BURN_STARTS_previous) + MASS_COMBUSTION_PRODUCTS_previous").withVariables("TIME_SINCE_BURN_STARTS_previous", "MASS_COMBUSTION_PRODUCTS_previous").withDependencies("MASS_STORAGE_RATE", "TIME_SINCE_BURN_STARTS")),
    DENSITY_COMBUSTION_PRODUCTS(new FormulaConfiguration("MASS_COMBUSTION_PRODUCTS / FreeVolumeInChamber(vc, GRAIN_VOLUME)").withDependencies("MASS_COMBUSTION_PRODUCTS", "GRAIN_VOLUME").withConstants(JSRMConstant.vc).withFunctions(Functions.access$700())),
    CHAMBER_PRESSURE_MPA(new FormulaConfiguration("(DENSITY_COMBUSTION_PRODUCTS * rat * to + patm * 1000000) / 1000000").withDependencies("DENSITY_COMBUSTION_PRODUCTS").withConstants(JSRMConstant.rat, JSRMConstant.to, JSRMConstant.patm)),
    ABSOLUTE_CHAMBER_PRESSURE(new FormulaConfiguration("CHAMBER_PRESSURE_MPA - patm").withDependencies("CHAMBER_PRESSURE_MPA").withConstants(JSRMConstant.patm)),
    ABSOLUTE_CHAMBER_PRESSURE_PSIG(new FormulaConfiguration("ABSOLUTE_CHAMBER_PRESSURE * 1000000 / 6895").withDependencies("ABSOLUTE_CHAMBER_PRESSURE")),
    AI(new FormulaConfiguration("(TEMPORARY_CHAMBER_PRESSURE - patm) * 1000000 * NOZZLE_CRITICAL_PASSAGE_AREA / sqrt(rat*to) * sqrt(k) * (2/(k+1))^((k+1)/2/(k-1))").withDependencies("TEMPORARY_CHAMBER_PRESSURE", "NOZZLE_CRITICAL_PASSAGE_AREA").withConstants(JSRMConstant.patm, JSRMConstant.rat, JSRMConstant.to, JSRMConstant.k)),
    KN(new FormulaConfiguration("(GRAIN_END_BURNING_SURFACE + GRAIN_CORE_BURNING_SURFACE + GRAIN_OUTER_BURNING_SURFACE) / throatArea").withDependencies("GRAIN_END_BURNING_SURFACE", "GRAIN_CORE_BURNING_SURFACE", "GRAIN_OUTER_BURNING_SURFACE").withVariables("throatArea"));

    private final Expression expression;
    private final Set<String> dependencies;
    private final String expressionAsString;

    private PressureFormulas(FormulaConfiguration config) {
        this.expressionAsString = config.getFormula();
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.expressionAsString);
        this.dependencies = Stream.of(config.getDependencies()).peek(arg_0 -> ((ExpressionBuilder)expressionBuilder).variable(arg_0)).collect(Collectors.toSet());
        expressionBuilder.functions(config.getFunctions());
        Stream.of(config.getConstants()).map(Enum::toString).forEach(arg_0 -> ((ExpressionBuilder)expressionBuilder).variable(arg_0));
        Stream.of(config.getVariables()).forEach(arg_0 -> ((ExpressionBuilder)expressionBuilder).variable(arg_0));
        this.expression = expressionBuilder.build();
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public String getExpressionAsString() {
        return this.expressionAsString;
    }

    @Override
    public Set<Formula> getDependencies() {
        return this.dependencies.stream().map(PressureFormulas::valueOf).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getVariablesNames() {
        return this.expression.getVariableNames();
    }

    private static class Functions {
        private static final CircleAreaFunction circleArea = new CircleAreaFunction();
        private static final ErosiveBurnFactorFunction erosiveBurnFactor = new ErosiveBurnFactorFunction();
        private static final HollowCircleAreaFunction hollowCircleArea = new HollowCircleAreaFunction();
        private static final BurnRateCharacteristicFunction burnRateCharacteristic = new BurnRateCharacteristicFunction();
        private static final GrainMassFunction grainMass = new GrainMassFunction();
        private static final NozzleMassFlowRateFunction nozzleMassFlowRate = new NozzleMassFlowRateFunction();
        private static final FreeVolumeInChamberFunction freeVolumeInChamber = new FreeVolumeInChamberFunction();
        private static final LowKnFunction lowKNFunction = new LowKnFunction();

        private Functions() {
        }

        static /* synthetic */ CircleAreaFunction access$000() {
            return circleArea;
        }

        static /* synthetic */ HollowCircleAreaFunction access$100() {
            return hollowCircleArea;
        }

        static /* synthetic */ ErosiveBurnFactorFunction access$200() {
            return erosiveBurnFactor;
        }

        static /* synthetic */ BurnRateCharacteristicFunction access$300() {
            return burnRateCharacteristic;
        }

        static /* synthetic */ GrainMassFunction access$400() {
            return grainMass;
        }

        static /* synthetic */ NozzleMassFlowRateFunction access$500() {
            return nozzleMassFlowRate;
        }

        static /* synthetic */ LowKnFunction access$600() {
            return lowKNFunction;
        }

        static /* synthetic */ FreeVolumeInChamberFunction access$700() {
            return freeVolumeInChamber;
        }
    }
}

