/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.grain.core;

import com.github.jbgust.jsrm.application.motor.grain.GrainConfigutation;
import com.github.jbgust.jsrm.application.motor.grain.core.BurningShape;
import com.github.jbgust.jsrm.application.motor.grain.core.ShapeUtil;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public abstract class RotatedShapeGrain
implements GrainConfigutation {
    protected Quality quality = Quality.Low;
    protected BurningShape shape = new BurningShape();
    protected double web = -1.0;

    public Area getCrossSection(double regression) {
        Area ret = new Area();
        for (Area a : ShapeUtil.separate(this.shape.getShape(regression))) {
            Rectangle2D b = a.getBounds2D();
            Ellipse2D.Double inner = new Ellipse2D.Double(-b.getMinX(), -b.getMinX(), b.getMinX() * 2.0, b.getMinX() * 2.0);
            Ellipse2D.Double outer = new Ellipse2D.Double(-b.getMaxX(), -b.getMaxX(), b.getMaxX() * 2.0, b.getMaxX() * 2.0);
            Area aa = new Area(outer);
            aa.subtract(new Area(inner));
            ret.add(aa);
        }
        return ret;
    }

    public double surfaceArea(double regression) {
        if (regression > this.webThickness()) {
            return 0.0;
        }
        Area burn = this.shape.getShape(regression);
        if (burn.isEmpty()) {
            return 0.0;
        }
        burn.subtract(this.shape.getShape(regression + this.quality.surfaceAreaStep));
        double sqmm = this.yRotatedSurfaceArea(burn);
        return sqmm / 2.0;
    }

    public double volume(double regression) {
        Shape squared = this.square(this.shape.getShape(regression));
        double sum = 0.0;
        sum = ShapeUtil.area(squared);
        double v = sum * Math.PI;
        return v;
    }

    public double webThickness() {
        double guess;
        if (this.web != -1.0) {
            return this.web;
        }
        Area a = this.shape.getShape(0.0);
        Rectangle r = a.getBounds();
        double max = r.getWidth() < r.getHeight() ? r.getHeight() : r.getWidth();
        double min = 0.0;
        do {
            if ((a = this.shape.getShape(guess = min + (max - min) / 2.0)).isEmpty()) {
                max = guess;
                continue;
            }
            min = guess;
        } while (!(max - min < 0.01));
        this.web = guess;
        return this.web;
    }

    private Shape square(Shape a) {
        PathIterator i = a.getPathIterator(new AffineTransform(), this.quality.squareFlatteningError);
        GeneralPath cur = new GeneralPath();
        double[] last = new double[]{0.0, 0.0};
        while (!i.isDone()) {
            double[] coords = new double[6];
            int type = i.currentSegment(coords);
            switch (type) {
                case 4: {
                    cur.closePath();
                    break;
                }
                case 0: {
                    cur.moveTo(Math.pow(coords[0], 2.0), coords[1]);
                    last[0] = coords[0];
                    last[1] = coords[1];
                    break;
                }
                case 3: {
                    throw new Error("Non-flattened geometry!");
                }
                case 1: {
                    double x = last[0];
                    double y = last[1];
                    double len = Math.sqrt(Math.pow(last[0] - coords[0], 2.0) + Math.pow(last[1] - coords[1], 2.0));
                    int steps = (int)(len / this.quality.squareSubdivide) + 5;
                    for (int s = 0; s < steps; ++s) {
                        cur.lineTo(Math.pow(x += (coords[0] - last[0]) / (double)steps, 2.0), y += (coords[1] - last[1]) / (double)steps);
                    }
                    last[0] = coords[0];
                    last[1] = coords[1];
                    break;
                }
                case 2: {
                    throw new Error("Non-flattened geometry!");
                }
            }
            i.next();
        }
        return cur;
    }

    private double yRotatedSurfaceArea(Shape a) {
        PathIterator i = a.getPathIterator(new AffineTransform(), this.quality.areaFlatteningError);
        double x = 0.0;
        double y = 0.0;
        double mx = 0.0;
        double my = 0.0;
        double len = 0.0;
        while (!i.isDone()) {
            double[] coords = new double[6];
            int type = i.currentSegment(coords);
            if (type == 1 || type == 4) {
                double nx = coords[0];
                double ny = coords[1];
                if (type == 4) {
                    nx = mx;
                    ny = my;
                }
                double dy = Math.abs(y - ny);
                double dx = Math.abs(x - nx);
                double xl = x > nx ? x : nx;
                double xs = x < nx ? x : nx;
                double add = 0.0;
                if (dx == 0.0) {
                    add = Math.PI * 2 * xl * dy;
                } else if (dy == 0.0) {
                    add = Math.PI * xl * xl - Math.PI * xs * xs;
                } else {
                    double h = xl / dx * dy;
                    double s1 = Math.sqrt(xl * xl + h * h);
                    double s2 = Math.sqrt(xs * xs + (h - dy) * (h - dy));
                    add = Math.PI * (xl * s1 - xs * s2);
                }
                len += add;
                x = nx;
                y = ny;
            } else if (type == 0) {
                mx = x = coords[0];
                my = y = coords[1];
            } else {
                throw new Error("Non-flattened geometry!");
            }
            i.next();
        }
        return len;
    }

    public static enum Quality {
        High{
            {
                this.surfaceAreaStep = 0.001;
                this.squareFlatteningError = 0.001;
                this.squareSubdivide = 0.01;
                this.areaFlatteningError = 0.001;
            }
        }
        ,
        Low{
            {
                this.surfaceAreaStep = 0.001;
                this.squareFlatteningError = 0.1;
                this.squareSubdivide = 0.1;
                this.areaFlatteningError = 0.1;
            }
        };

        double surfaceAreaStep = 0.001;
        double squareFlatteningError = 0.001;
        double squareSubdivide = 0.01;
        double areaFlatteningError = 0.001;
    }
}

