/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.grain;

import com.github.jbgust.jsrm.application.exception.InvalidMotorDesignException;
import com.github.jbgust.jsrm.application.motor.SolidRocketMotor;
import com.github.jbgust.jsrm.application.motor.grain.core.BurningShape;
import com.github.jbgust.jsrm.application.motor.grain.core.RotatedShapeGrain;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public class EndBurner
extends RotatedShapeGrain {
    private final double length;
    private final double outerDiameter;
    private final double holeDiameter;
    private final double holeDepth;
    private Map<Double, Double> burningAreaCache = new HashMap<Double, Double>();

    public EndBurner(double length, double outerDiameter, double holeDiameter, double holeDepth) {
        this.length = length;
        this.outerDiameter = outerDiameter;
        this.holeDiameter = holeDiameter;
        this.holeDepth = holeDepth;
        this.generateGeometry();
    }

    private void generateGeometry() {
        Rectangle2D.Double grain = new Rectangle2D.Double(0.0, 0.0, this.outerDiameter / 2.0, this.length);
        Rectangle2D.Double punt = new Rectangle2D.Double(0.0, this.length - this.holeDepth, this.holeDiameter / 2.0, this.holeDepth);
        Rectangle2D.Double end = new Rectangle2D.Double(0.0, this.length, this.outerDiameter, 0.0);
        this.shape = new BurningShape();
        this.web = -1.0;
        this.shape.add(grain);
        this.shape.inhibit(grain);
        this.shape.subtract(punt);
        this.shape.subtract(end);
    }

    @Override
    public double getGrainEndSurface(double burnProgression) {
        return this.getCachedBurningArea(this.getRegression(burnProgression));
    }

    private double getRegression(double burnProgression) {
        return burnProgression * this.webThickness();
    }

    private double getCachedBurningArea(double regression) {
        return this.burningAreaCache.computeIfAbsent(regression, currentRegression -> this.surfaceArea(regression));
    }

    @Override
    public double getGrainVolume(double burnProgression) {
        return this.volume(this.getRegression(burnProgression));
    }

    @Override
    public double getBurningArea(double burnProgression) {
        return this.getCachedBurningArea(this.getRegression(burnProgression));
    }

    @Override
    public double getXincp(int numberOfPoints) {
        return this.webThickness() / (double)numberOfPoints;
    }

    @Override
    public void checkConfiguration(SolidRocketMotor solidRocketMotor) throws InvalidMotorDesignException {
        if (this.outerDiameter <= 0.0) {
            throw new InvalidMotorDesignException("Outer diameter should be > 0");
        }
        if (this.length <= 0.0) {
            throw new InvalidMotorDesignException("Grain length should be > 0");
        }
        if (this.holeDiameter > this.outerDiameter) {
            throw new InvalidMotorDesignException("Hole diameter should be < than outer diameter");
        }
        if (this.holeDepth > this.length) {
            throw new InvalidMotorDesignException("Hole length diameter should be < than grain length");
        }
    }
}

