/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.infra.pressure;

import com.github.jbgust.jsrm.application.JSRMConfig;
import com.github.jbgust.jsrm.application.motor.SolidRocketMotor;
import com.github.jbgust.jsrm.calculation.CalculatorBuilder;
import com.github.jbgust.jsrm.calculation.CalculatorResults;
import com.github.jbgust.jsrm.calculation.Formula;
import com.github.jbgust.jsrm.infra.ConstantsExtractor;
import com.github.jbgust.jsrm.infra.JSRMConstant;
import com.github.jbgust.jsrm.infra.pressure.IncrementTimeBurstSolver;
import com.github.jbgust.jsrm.infra.pressure.KnDependenciesResultsProvider;
import com.github.jbgust.jsrm.infra.pressure.PostBurnPressureFormulas;
import com.github.jbgust.jsrm.infra.pressure.PressureFormulas;
import com.github.jbgust.jsrm.infra.pressure.resultprovider.BurningSurfaceResultProvider;
import com.github.jbgust.jsrm.infra.pressure.resultprovider.EndGrainSurfaceResultProvider;
import com.github.jbgust.jsrm.infra.pressure.resultprovider.GrainVolumeResultProvider;
import com.github.jbgust.jsrm.infra.pressure.resultprovider.ProgressionResultProvider;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ChamberPressureCalculation {
    private SolidRocketMotor motor;
    private JSRMConfig config;
    private final Map<JSRMConstant, Double> constants;
    private final Map<Formula, Double> initialValues;

    public ChamberPressureCalculation(SolidRocketMotor motor, JSRMConfig config, Map<JSRMConstant, Double> constants) {
        this.motor = motor;
        this.config = config;
        this.constants = constants;
        this.initialValues = this.getInitialValues(motor, config);
    }

    public Map<Results, List<Double>> compute() {
        CalculatorResults pressureResults = this.computeChamberPressureDuringPropellantBurn();
        CalculatorResults knResults = this.computeKn(pressureResults);
        this.addNewConstantsFromPressureResults(pressureResults);
        CalculatorResults postBurnPressureResults = this.computePostBurnPressure();
        return this.buildResults(pressureResults, knResults, postBurnPressureResults);
    }

    private CalculatorResults computeKn(CalculatorResults pressureResults) {
        return new CalculatorBuilder(PressureFormulas.KN).withResultsToSave(PressureFormulas.KN).withConstants(ConstantsExtractor.toCalculationFormat(this.constants)).withResultLineProviders(new BurningSurfaceResultProvider(this.motor.getPropellantGrain().getGrainConfigutation(), this.config.getNumberLineDuringBurnCalculation()), new KnDependenciesResultsProvider(Results.throatArea.name(), pressureResults.getResults(PressureFormulas.THROAT_AREA))).createCalculator().compute(0, this.config.getNumberLineDuringBurnCalculation());
    }

    private Map<Results, List<Double>> buildResults(CalculatorResults pressureResults, CalculatorResults knResults, CalculatorResults postBurnPressureResults) {
        int lastPressureResultsLine = this.config.getNumberLineDuringBurnCalculation() - 1;
        ArrayList<Double> throatAreaResults = new ArrayList<Double>(pressureResults.getResults(PressureFormulas.THROAT_AREA));
        IntStream.range(0, this.config.getNumberLineDuringPostBurnCalculation() + 1).forEach(value -> throatAreaResults.add(pressureResults.getResult(PressureFormulas.THROAT_AREA, lastPressureResultsLine)));
        ArrayList<Double> knResultValues = new ArrayList<Double>(knResults.getResults(PressureFormulas.KN));
        IntStream.range(0, this.config.getNumberLineDuringPostBurnCalculation() + 1).forEach(value -> knResultValues.add(0.0));
        ArrayList<Double> massFlowRateValues = new ArrayList<Double>(pressureResults.getResults(PressureFormulas.NOZZLE_MASS_FLOW_RATE));
        ArrayList<Double> grainMassValues = new ArrayList<Double>(pressureResults.getResults(PressureFormulas.GRAIN_MASS));
        double lastMassFlowRateComputed = (Double)massFlowRateValues.get(massFlowRateValues.size() - 1);
        double massflowIncrement = lastMassFlowRateComputed / (double)(this.config.getNumberLineDuringPostBurnCalculation() + 1);
        IntStream.range(0, this.config.getNumberLineDuringPostBurnCalculation() + 1).forEach(value -> massFlowRateValues.add(lastMassFlowRateComputed - massflowIncrement * (double)(value + 1)));
        IntStream.range(0, this.config.getNumberLineDuringPostBurnCalculation() + 1).forEach(value -> grainMassValues.add(0.0));
        ArrayList<Double> nozzlePassageAreaResults = new ArrayList<Double>(pressureResults.getResults(PressureFormulas.NOZZLE_CRITICAL_PASSAGE_AREA));
        IntStream.range(0, this.config.getNumberLineDuringPostBurnCalculation() + 1).forEach(value -> nozzlePassageAreaResults.add(pressureResults.getResult(PressureFormulas.NOZZLE_CRITICAL_PASSAGE_AREA, lastPressureResultsLine)));
        List<Double> timeSinceBurnStartResults = this.mergeResults(pressureResults, postBurnPressureResults, PressureFormulas.TIME_SINCE_BURN_STARTS, PostBurnPressureFormulas.POST_BURN_TIME_SINCE_BURN_STARTS);
        List<Double> chamberPressureMPAResults = this.mergeResults(pressureResults, postBurnPressureResults, PressureFormulas.CHAMBER_PRESSURE_MPA, PostBurnPressureFormulas.POST_BURN_CHAMBER_PRESSURE_MPA);
        List<Double> absoluteChamberPressureResults = this.mergeResults(pressureResults, postBurnPressureResults, PressureFormulas.ABSOLUTE_CHAMBER_PRESSURE, PostBurnPressureFormulas.POST_BURN_ABSOLUTE_CHAMBER_PRESSURE);
        List<Double> absoluteChamberPressurePSIGResults = this.mergeResults(pressureResults, postBurnPressureResults, PressureFormulas.ABSOLUTE_CHAMBER_PRESSURE_PSIG, PostBurnPressureFormulas.POST_BURN_ABSOLUTE_CHAMBER_PRESSURE_PSIG);
        timeSinceBurnStartResults.add(this.constants.get((Object)JSRMConstant.tbinc) + timeSinceBurnStartResults.get(timeSinceBurnStartResults.size() - 1));
        chamberPressureMPAResults.add(0.0);
        absoluteChamberPressureResults.add(0.0);
        absoluteChamberPressurePSIGResults.add(0.0);
        return ImmutableMap.builder().put((Object)Results.throatArea, throatAreaResults).put((Object)Results.nozzleCriticalPassageArea, nozzlePassageAreaResults).put((Object)Results.timeSinceBurnStart, timeSinceBurnStartResults).put((Object)Results.chamberPressureMPA, chamberPressureMPAResults).put((Object)Results.absoluteChamberPressure, absoluteChamberPressureResults).put((Object)Results.absoluteChamberPressurePSIG, absoluteChamberPressurePSIGResults).put((Object)Results.kn, knResultValues).put((Object)Results.massFlowRate, massFlowRateValues).put((Object)Results.grainMass, grainMassValues).put((Object)Results.lowKNCorrection, Collections.singletonList(this.countLowKNFunctionUsage(pressureResults))).build();
    }

    private double countLowKNFunctionUsage(CalculatorResults pressureResults) {
        if (this.constants.get((Object)JSRMConstant.safeKN) == 1.0) {
            return Long.valueOf(pressureResults.getResults(PressureFormulas.MASS_STORAGE_RATE).stream().filter(massStorageRate -> Double.compare(1.0E-4, massStorageRate) == 0).count()).doubleValue();
        }
        return 0.0;
    }

    private List<Double> mergeResults(CalculatorResults pressureResults, CalculatorResults postBurnPressureResults, PressureFormulas pressureFormulas, PostBurnPressureFormulas postBurnPressureFormulas) {
        return Stream.concat(pressureResults.getResults(pressureFormulas).stream(), postBurnPressureResults.getResults(postBurnPressureFormulas).stream()).collect(Collectors.toList());
    }

    private CalculatorResults computePostBurnPressure() {
        this.initialValues.put(PostBurnPressureFormulas.POST_BURN_TIME_SINCE_BURN_STARTS, this.constants.get((Object)JSRMConstant.tbout) + this.constants.get((Object)JSRMConstant.tbinc));
        return new CalculatorBuilder(PostBurnPressureFormulas.POST_BURN_ABSOLUTE_CHAMBER_PRESSURE_PSIG).withConstants(ConstantsExtractor.toCalculationFormat(this.constants)).withInitialValues(this.initialValues).withResultsToSave(PostBurnPressureFormulas.values()).createCalculator().compute(0, this.config.getNumberLineDuringPostBurnCalculation());
    }

    private CalculatorResults computeChamberPressureDuringPropellantBurn() {
        return new CalculatorBuilder(PressureFormulas.ABSOLUTE_CHAMBER_PRESSURE_PSIG).withConstants(ConstantsExtractor.toCalculationFormat(this.constants)).withInitialValues(this.initialValues).withResultsToSave(PressureFormulas.THROAT_AREA, PressureFormulas.NOZZLE_CRITICAL_PASSAGE_AREA, PressureFormulas.TIME_SINCE_BURN_STARTS, PressureFormulas.CHAMBER_PRESSURE_MPA, PressureFormulas.ABSOLUTE_CHAMBER_PRESSURE, PressureFormulas.ABSOLUTE_CHAMBER_PRESSURE_PSIG, PressureFormulas.NOZZLE_MASS_FLOW_RATE, PressureFormulas.GRAIN_MASS, PressureFormulas.MASS_STORAGE_RATE).withResultLineProviders(new ProgressionResultProvider(this.config.getNumberLineDuringBurnCalculation()), new EndGrainSurfaceResultProvider(this.motor.getPropellantGrain().getGrainConfigutation(), this.config.getNumberLineDuringBurnCalculation()), new GrainVolumeResultProvider(this.motor.getPropellantGrain().getGrainConfigutation(), this.config.getNumberLineDuringBurnCalculation())).createCalculator().compute(0, this.config.getNumberLineDuringBurnCalculation());
    }

    private void addNewConstantsFromPressureResults(CalculatorResults pressureResults) {
        int lastPressureResultsLine = this.config.getNumberLineDuringBurnCalculation() - 1;
        this.constants.put(JSRMConstant.tbout, pressureResults.getResult(PressureFormulas.TIME_SINCE_BURN_STARTS, lastPressureResultsLine));
        this.constants.put(JSRMConstant.pbout, pressureResults.getResult(PressureFormulas.CHAMBER_PRESSURE_MPA, lastPressureResultsLine));
        this.constants.put(JSRMConstant.astarf, pressureResults.getResult(PressureFormulas.NOZZLE_CRITICAL_PASSAGE_AREA, lastPressureResultsLine));
        this.constants.put(JSRMConstant.expectedPfinal, 2.0 * this.constants.get((Object)JSRMConstant.patm) + 2.0E-4 * this.getPmax(pressureResults));
        this.constants.put(JSRMConstant.tbinc, this.getTbinc(this.constants));
    }

    private double getPmax(CalculatorResults pressureResults) {
        return (Double)pressureResults.getResults(PressureFormulas.ABSOLUTE_CHAMBER_PRESSURE).stream().max(Double::compareTo).get();
    }

    private Double getTbinc(Map<JSRMConstant, Double> constants) {
        Map<String, Double> tbincVariables = Stream.of(JSRMConstant.vc, JSRMConstant.expectedPfinal, JSRMConstant.pbout, JSRMConstant.rat, JSRMConstant.to, JSRMConstant.astarf, JSRMConstant.cstar).collect(Collectors.toMap(Enum::name, constants::get));
        tbincVariables.put("nbLine", Double.valueOf(this.config.getNumberLineDuringPostBurnCalculation()));
        return new IncrementTimeBurstSolver().solve(tbincVariables);
    }

    private Map<Formula, Double> getInitialValues(SolidRocketMotor motor, JSRMConfig config) {
        HashMap<Formula, Double> initialValues = new HashMap<Formula, Double>();
        initialValues.put(PressureFormulas.TEMPORARY_CHAMBER_PRESSURE, config.getAmbiantPressureInMPa());
        initialValues.put(PressureFormulas.TIME_SINCE_BURN_STARTS, 0.0);
        initialValues.put(PressureFormulas.MASS_GENERATION_RATE, 0.0);
        initialValues.put(PressureFormulas.NOZZLE_MASS_FLOW_RATE, 0.0);
        initialValues.put(PressureFormulas.MASS_STORAGE_RATE, 0.0);
        initialValues.put(PressureFormulas.MASS_COMBUSTION_PRODUCTS, 0.0);
        initialValues.put(PressureFormulas.DENSITY_COMBUSTION_PRODUCTS, 0.0);
        return initialValues;
    }

    public static enum Results {
        throatArea,
        nozzleCriticalPassageArea,
        timeSinceBurnStart,
        chamberPressureMPA,
        absoluteChamberPressure,
        absoluteChamberPressurePSIG,
        kn,
        massFlowRate,
        lowKNCorrection,
        grainMass;

    }
}

