/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.propellant;

import com.github.jbgust.jsrm.application.exception.ChamberPressureOutOfBoundException;
import com.github.jbgust.jsrm.application.motor.propellant.SolidPropellant;
import com.github.jbgust.jsrm.infra.propellant.BurnRateData;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;

public enum PropellantType implements SolidPropellant
{
    KNDX("KNDX = Potassium Nitrate/Dextrose, 65/35 O/F ratio", 1.879, 1.1308, 1.1308, 42.42, 1710.0, (RangeMap<Double, BurnRateData>)new ImmutableRangeMap.Builder().put(Range.lessThan((Comparable)Double.valueOf(0.779135)), (Object)new BurnRateData(8.87544496778536, 0.6193)).put(Range.closedOpen((Comparable)Double.valueOf(0.779135), (Comparable)Double.valueOf(2.571835)), (Object)new BurnRateData(7.55278442387944, -0.0087)).put(Range.closedOpen((Comparable)Double.valueOf(2.571835), (Comparable)Double.valueOf(5.9297)), (Object)new BurnRateData(3.84087990499602, 0.6882)).put(Range.closedOpen((Comparable)Double.valueOf(5.9297), (Comparable)Double.valueOf(8.501535)), (Object)new BurnRateData(17.2041864098062, -0.1481)).put(Range.atLeast((Comparable)Double.valueOf(8.501535)), (Object)new BurnRateData(4.77524086347659, 0.4417)).build(), 1),
    KNSB_FINE("KNSB fine = Potassium nitrate/sorbitol 65/35 O/F ratio, oxidizer finely milled", 1.841, 1.137, 1.137, 39.9, 1600.0, (RangeMap<Double, BurnRateData>)new ImmutableRangeMap.Builder().put(Range.lessThan((Comparable)Double.valueOf(0.806715)), (Object)new BurnRateData(10.7076837980331, 0.6247)).put(Range.closedOpen((Comparable)Double.valueOf(0.806715), (Comparable)Double.valueOf(1.50311)), (Object)new BurnRateData(8.76328007101773, -0.3142)).put(Range.closedOpen((Comparable)Double.valueOf(1.50311), (Comparable)Double.valueOf(3.79225)), (Object)new BurnRateData(7.85216579497841, -0.013)).put(Range.closedOpen((Comparable)Double.valueOf(3.79225), (Comparable)Double.valueOf(7.0329)), (Object)new BurnRateData(3.90676830413905, 0.5354)).put(Range.atLeast((Comparable)Double.valueOf(7.0329)), (Object)new BurnRateData(9.65320361987685, 0.0638)).build(), 2),
    KNSB_COARSE("KNSB coarse = Potassium nitrate/sorbitol 65/35 O/F ratio, oxidizer granular or lightly milled prills", 1.841, 1.137, 1.137, 39.9, 1600.0, (RangeMap<Double, BurnRateData>)new ImmutableRangeMap.Builder().put(Range.all(), (Object)new BurnRateData(5.13, 0.22)).build(), 3),
    KNSU("KNSU = Potassium nitrate/sucrose 65/35 O/F ratio, oxidizer finely milled", 1.889, 1.133, 1.133, 42.02, 1720.0, (RangeMap<Double, BurnRateData>)new ImmutableRangeMap.Builder().put(Range.all(), (Object)new BurnRateData(8.26, 0.319)).build(), 4),
    KNER_COARSE("KNER coarse = Potassium nitrate/erythritol 65/35 O/F ratio, oxidizer granular or lightly milled prills", 1.82, 1.14, 1.14, 38.58, 1608.0, (RangeMap<Double, BurnRateData>)new ImmutableRangeMap.Builder().put(Range.all(), (Object)new BurnRateData(2.9, 0.4)).build(), 5),
    KNMN_COARSE("KNMN coarse = Potassium nitrate/mannitol 65/35 O/F ratio, oxidizer granular or lightly milled prills", 1.854, 1.1363, 1.1363, 39.826, 1616.0, (RangeMap<Double, BurnRateData>)new ImmutableRangeMap.Builder().put(Range.all(), (Object)new BurnRateData(5.13, 0.22)).build(), 6),
    KNXY("KNXY = Potassium nitrate/Xylitol 65/35 O/F ratio", 1.8654, 1.138, 1.138, 39.293, 1623.0, (RangeMap<Double, BurnRateData>)new ImmutableRangeMap.Builder().put(Range.all(), (Object)new BurnRateData(3.23, 0.483)).build(), 7),
    KNFR("KNFR = Potassium Nitrate/Fructose 65/35 O/F ratio", 1.942, 1.1308, 1.1308, 42.42, 1710.0, (RangeMap<Double, BurnRateData>)new ImmutableRangeMap.Builder().put(Range.all(), (Object)new BurnRateData(7.4, 0.25)).build(), 8),
    KNPSB("KNPSB = Potassium Nitrate/Potassium Perchlorate/Sorbitol 35/30/35 O/O/F ratio", 1.923, 1.163, 1.163, 36.39, 1858.0, (RangeMap<Double, BurnRateData>)new ImmutableRangeMap.Builder().put(Range.all(), (Object)new BurnRateData(6.5, 0.628)).build(), 9);

    private final RangeMap<Double, BurnRateData> byPressureData;
    private final String description;
    private final double idealMassDensity;
    private final double k2Ph;
    private final double k;
    private final double effectiveMolecularWeight;
    private final double chamberTemperature;
    private final int id;

    private PropellantType(String description, double idealMassDensity, double k2Ph, double k, double effectiveMolecularWeight, double chamberTemperature, RangeMap<Double, BurnRateData> byPressureData, int id) {
        this.byPressureData = byPressureData;
        this.description = description;
        this.idealMassDensity = idealMassDensity;
        this.k2Ph = k2Ph;
        this.k = k;
        this.effectiveMolecularWeight = effectiveMolecularWeight;
        this.chamberTemperature = chamberTemperature;
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public double getIdealMassDensity() {
        return this.idealMassDensity;
    }

    @Override
    public double getK2Ph() {
        return this.k2Ph;
    }

    @Override
    public double getK() {
        return this.k;
    }

    @Override
    public double getEffectiveMolecularWeight() {
        return this.effectiveMolecularWeight;
    }

    @Override
    public double getChamberTemperature() {
        return this.chamberTemperature;
    }

    @Override
    public double getBurnRateCoefficient(double chamberPressure) throws ChamberPressureOutOfBoundException {
        BurnRateData burnRateData = (BurnRateData)this.byPressureData.get((Comparable)Double.valueOf(chamberPressure));
        if (burnRateData != null) {
            return burnRateData.burnRateCoefficient();
        }
        throw new ChamberPressureOutOfBoundException(this.name() + " has no burn rate coefficient for this pressure (" + chamberPressure + ") should be in range " + this.byPressureData.span());
    }

    @Override
    public double getPressureExponent(double chamberPressure) throws ChamberPressureOutOfBoundException {
        BurnRateData burnRateData = (BurnRateData)this.byPressureData.get((Comparable)Double.valueOf(chamberPressure));
        if (burnRateData != null) {
            return burnRateData.pressureExponent();
        }
        throw new ChamberPressureOutOfBoundException(this.name() + " has no pressure exponent for this pressure (" + chamberPressure + ") should be in range " + this.byPressureData.span());
    }

    public int getId() {
        return this.id;
    }
}

