/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.FieldProcessor;
import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.MetaCSVRecord;
import com.github.jferard.javamcsv.ProcessorProvider;
import java.util.ArrayList;
import org.apache.commons.csv.CSVRecord;

public class CSVRecordProcessor {
    private final ProcessorProvider provider;

    CSVRecordProcessor(ProcessorProvider provider) {
        this.provider = provider;
    }

    public MetaCSVRecord process(CSVRecord record) throws MetaCSVReadException {
        ArrayList<Object> values = new ArrayList<Object>(record.size());
        for (int i = 0; i < record.size(); ++i) {
            FieldProcessor<?> processor = this.provider.getProcessor(i);
            String s = record.get(i);
            values.add(processor.toObject(s));
        }
        return new MetaCSVRecord(record, values);
    }
}

