/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.DateFieldDescription;
import com.github.jferard.javamcsv.DateFieldProcessor;
import com.github.jferard.javamcsv.FieldDescription;
import com.github.jferard.javamcsv.FieldProcessor;
import com.github.jferard.javamcsv.Util;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DatetimeFieldDescription
implements FieldDescription<Date> {
    public static final FieldDescription<?> INSTANCE = DateFieldDescription.create("yyyy-MM-dd'T'HH:mm:ss");
    private SimpleDateFormat simpleDateFormat;
    private String locale;
    private String nullValue;

    public static FieldDescription<Date> create(String dateFormat) {
        return new DatetimeFieldDescription(new SimpleDateFormat(dateFormat), null);
    }

    public static FieldDescription<Date> create(String dateFormat, String locale) {
        return new DatetimeFieldDescription(new SimpleDateFormat(dateFormat, Locale.getDefault()), locale);
    }

    public DatetimeFieldDescription(SimpleDateFormat simpleDateFormat, String locale) {
        this.simpleDateFormat = simpleDateFormat;
        this.locale = locale;
        this.nullValue = "";
    }

    @Override
    public void render(Appendable out) throws IOException {
        out.append("datetime/");
        Util.render(out, this.simpleDateFormat.toPattern());
        if (this.locale != null) {
            out.append('/').append(this.locale);
        }
    }

    @Override
    public FieldProcessor<Date> toFieldProcessor(String nullValue) {
        return new DateFieldProcessor(this.simpleDateFormat, this.locale, nullValue);
    }

    @Override
    public Class<Date> getJavaType() {
        return Date.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.DATETIME;
    }

    public String toString() {
        return String.format("DatetimeDescription(%s, %s)", this.simpleDateFormat.toPattern(), this.locale);
    }
}

