/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.FieldProcessor;
import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.Util;

public class FloatFieldProcessor
implements FieldProcessor<Double> {
    private final String thousandsSeparator;
    private final String decimalSeparator;
    private final String nullValue;

    public FloatFieldProcessor(String thousandsSeparator, String decimalSeparator, String nullValue) {
        this.thousandsSeparator = thousandsSeparator;
        this.decimalSeparator = decimalSeparator;
        this.nullValue = nullValue;
    }

    @Override
    public Double toObject(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return null;
        }
        try {
            return Util.parseDouble(text, this.thousandsSeparator, this.decimalSeparator);
        }
        catch (NumberFormatException e) {
            throw new MetaCSVReadException(e);
        }
    }

    @Override
    public String toString(Double d) {
        if (d == null) {
            return this.nullValue;
        }
        return Util.formatDouble(d, this.thousandsSeparator, this.decimalSeparator);
    }
}

