/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.FieldDescription;
import com.github.jferard.javamcsv.FieldProcessor;
import com.github.jferard.javamcsv.IntegerFieldProcessor;
import java.io.IOException;

public class IntegerFieldDescription
implements FieldDescription<Long> {
    public static IntegerFieldDescription INSTANCE = new IntegerFieldDescription(null);
    private final String thousandsSeparator;

    public IntegerFieldDescription(String thousandsSeparator) {
        this.thousandsSeparator = thousandsSeparator;
    }

    @Override
    public void render(Appendable out) throws IOException {
        if (this.thousandsSeparator == null || this.thousandsSeparator.isEmpty()) {
            out.append("integer");
        } else {
            out.append("integer/").append(this.thousandsSeparator);
        }
    }

    @Override
    public FieldProcessor<Long> toFieldProcessor(String nullValue) {
        return new IntegerFieldProcessor(this.thousandsSeparator, nullValue);
    }

    @Override
    public Class<Long> getJavaType() {
        return Long.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.INTEGER;
    }

    public String toString() {
        return String.format("IntegerFieldDescription(%s)", this.thousandsSeparator);
    }
}

