/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.FieldProcessor;
import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.Util;

public class IntegerFieldProcessor
implements FieldProcessor<Long> {
    private final String thousandsSeparator;
    private final String nullValue;

    public IntegerFieldProcessor(String thousandsSeparator, String nullValue) {
        this.thousandsSeparator = thousandsSeparator;
        this.nullValue = nullValue;
    }

    @Override
    public Long toObject(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return null;
        }
        try {
            return Util.parseLong(text, this.thousandsSeparator);
        }
        catch (NumberFormatException e) {
            throw new MetaCSVReadException(e);
        }
    }

    @Override
    public String toString(Long n) {
        if (n == null) {
            return this.nullValue;
        }
        return Util.formatLong(n, this.thousandsSeparator);
    }
}

