/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.FieldDescription;
import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVDataException;
import com.github.jferard.javamcsv.Util;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class MetaCSVDataBuilder {
    private String encoding = Util.UTF_8_CHARSET_NAME;
    private String lineTerminator = "\r\n";
    private char delimiter;
    private boolean doubleQuote = true;
    private char escapeChar;
    private char quoteChar;
    private boolean skipInitialSpace;
    private Map<Integer, FieldDescription<?>> descriptionByColIndex = new HashMap();
    private String nullValue = "";
    private boolean bom = false;
    private String metaVersion = "draft0";
    private Map<String, String> meta;

    public MetaCSVDataBuilder() {
        this.delimiter = (char)44;
        this.quoteChar = (char)34;
        this.meta = new HashMap<String, String>();
    }

    public MetaCSVData build() throws MetaCSVDataException {
        Charset charset;
        if (this.encoding.equals("UTF-8-SIG")) {
            charset = Util.UTF_8_CHARSET;
            this.bom = true;
        } else {
            charset = Charset.forName(this.encoding);
        }
        if (!charset.equals(Util.UTF_8_CHARSET) && this.bom) {
            throw new MetaCSVDataException("Can't have a bom with charset " + charset);
        }
        return new MetaCSVData(this.metaVersion, this.meta, charset, this.bom, Util.unescapeLineTerminator(this.lineTerminator), this.delimiter, this.doubleQuote, this.escapeChar, this.quoteChar, this.skipInitialSpace, this.nullValue, this.descriptionByColIndex);
    }

    public MetaCSVDataBuilder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public MetaCSVDataBuilder lineTerminator(String lineTerminator) {
        this.lineTerminator = lineTerminator;
        return this;
    }

    public MetaCSVDataBuilder delimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public MetaCSVDataBuilder doubleQuote(boolean doubleQuote) {
        this.doubleQuote = doubleQuote;
        return this;
    }

    public MetaCSVDataBuilder escapeChar(char escapeChar) {
        this.doubleQuote = false;
        this.escapeChar = escapeChar;
        return this;
    }

    public MetaCSVDataBuilder quoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    public MetaCSVDataBuilder skipInitialSpace(boolean skipInitialSpace) {
        this.skipInitialSpace = skipInitialSpace;
        return this;
    }

    public MetaCSVDataBuilder colType(int c, FieldDescription<?> fieldDescription) {
        this.descriptionByColIndex.put(c, fieldDescription);
        return this;
    }

    public MetaCSVDataBuilder nullValue(String nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    public MetaCSVDataBuilder bom(boolean value) {
        this.bom = value;
        return this;
    }

    public MetaCSVDataBuilder metaVersion(String metaVersion) {
        this.metaVersion = metaVersion;
        return this;
    }

    public MetaCSVDataBuilder meta(String key, String value) {
        this.meta.put(key, value);
        return this;
    }
}

