/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.MetaCSVCastException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.csv.CSVRecord;

public class MetaCSVRecord
implements Iterable<Object> {
    private CSVRecord record;
    private List<Object> values;

    public MetaCSVRecord(CSVRecord record, List<Object> values) {
        this.record = record;
        this.values = values;
    }

    public Boolean getBoolean(int i) throws MetaCSVCastException {
        Object value = this.values.get(i);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new MetaCSVCastException("Not a boolean: " + value);
    }

    public Date getDate(int i) {
        Object value = this.values.get(i);
        if (value instanceof Date) {
            Date date = (Date)value;
            Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.setTime(date);
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        throw new MetaCSVCastException("Not a date: " + value);
    }

    public Date getDatetime(int i) {
        Object value = this.values.get(i);
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new MetaCSVCastException("Not a datetime: " + value);
    }

    public BigDecimal getDecimal(int i) {
        Object value = this.values.get(i);
        if (value instanceof Number) {
            return (BigDecimal)value;
        }
        throw new MetaCSVCastException("Not a number: " + value);
    }

    public double getFloat(int i) {
        Object value = this.values.get(i);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new MetaCSVCastException("Not a number: " + value);
    }

    public long getInteger(int i) {
        Object value = this.values.get(i);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new MetaCSVCastException("Not a number: " + value);
    }

    public CharSequence getText(int i) {
        Object value = this.values.get(i);
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        throw new MetaCSVCastException("Not a text: " + value);
    }

    public Object getObject(int i) {
        return this.values.get(i);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    public int size() {
        return this.record.size();
    }

    public String toString() {
        return "MetaCSVRecord(" + this.record + " ," + this.values + ")";
    }
}

