/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.CSVFormatHelper;
import com.github.jferard.javamcsv.FieldProcessor;
import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVRenderer;
import com.github.jferard.javamcsv.ProcessorProvider;
import com.github.jferard.javamcsv.Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MetaCSVWriter
implements Closeable {
    private final ProcessorProvider provider;
    private final CSVPrinter printer;

    public static MetaCSVWriter create(File csvFile, MetaCSVData data) throws IOException {
        File metaCSVFile = Util.withExtension(csvFile, ".mcsv");
        return MetaCSVWriter.create(csvFile, metaCSVFile, data);
    }

    public static MetaCSVWriter create(File csvFile, File metaCSVFile, MetaCSVData data) throws IOException {
        FileOutputStream metaOut = new FileOutputStream(metaCSVFile);
        FileOutputStream out = new FileOutputStream(csvFile);
        return MetaCSVWriter.create(out, metaOut, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetaCSVWriter create(OutputStream out, OutputStream metaOut, MetaCSVData data) throws IOException {
        try {
            MetaCSVRenderer renderer = MetaCSVRenderer.create(metaOut);
            renderer.render(data);
        }
        finally {
            metaOut.close();
        }
        return MetaCSVWriter.create(out, data);
    }

    public static MetaCSVWriter create(OutputStream out, MetaCSVData data) throws IOException {
        CSVFormat format = CSVFormatHelper.getCSVFormat(data);
        OutputStreamWriter writer = new OutputStreamWriter(out, data.getEncoding());
        CSVPrinter printer = new CSVPrinter((Appendable)writer, format);
        return new MetaCSVWriter(printer, data);
    }

    private MetaCSVWriter(CSVPrinter printer, ProcessorProvider provider) {
        this.printer = printer;
        this.provider = provider;
    }

    @Override
    public void close() throws IOException {
        this.printer.close();
    }

    public void writeHeader(List<String> header) throws IOException {
        this.printer.printRecord(header);
    }

    public void writeRow(List<Object> values) throws IOException {
        ArrayList<String> formattedValues = new ArrayList<String>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            FieldProcessor<?> rawProcessor;
            Object value = values.get(i);
            FieldProcessor<?> processor = rawProcessor = this.provider.getProcessor(i);
            String formattedValue = processor.toString(value);
            formattedValues.add(formattedValue);
        }
        this.printer.printRecord(formattedValues);
    }
}

