/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.tool;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.FieldDescription;
import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVDataBuilder;
import com.github.jferard.javamcsv.MetaCSVDataException;
import com.github.jferard.javamcsv.MetaCSVRenderer;
import com.github.jferard.javamcsv.MetaCSVWriter;
import com.github.jferard.javamcsv.tool.SQLUtil;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ResultSetMetaCSVWriter {
    private ResultSet resultSet;

    public ResultSetMetaCSVWriter(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public void write(MetaCSVWriter writer, MetaCSVRenderer renderer) throws SQLException, IOException, MetaCSVDataException {
        this.write(writer, renderer, new MetaCSVDataBuilder());
    }

    private void write(MetaCSVWriter writer, MetaCSVRenderer renderer, MetaCSVDataBuilder dataBuilder) throws SQLException, MetaCSVDataException, IOException {
        MetaCSVData metaCSVData = this.getMetaCSVData(dataBuilder);
        renderer.render(metaCSVData);
        this.writeCSV(writer, metaCSVData);
    }

    public void writeMetaCSV(MetaCSVRenderer renderer) throws SQLException, MetaCSVDataException, IOException {
        this.writeMetaCSV(new MetaCSVDataBuilder(), renderer);
    }

    public void writeMetaCSV(MetaCSVDataBuilder dataBuilder, MetaCSVRenderer renderer) throws SQLException, MetaCSVDataException, IOException {
        MetaCSVData metaCSVData = this.getMetaCSVData(dataBuilder);
        renderer.render(metaCSVData);
    }

    public MetaCSVData getMetaCSVData(MetaCSVDataBuilder dataBuilder) throws SQLException, MetaCSVDataException {
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        MetaCSVData data0 = dataBuilder.build();
        int count = resultSetMetaData.getColumnCount();
        for (int c = 0; c < count; ++c) {
            if (data0.getDescription(c) != null) continue;
            int columnType = resultSetMetaData.getColumnType(c + 1);
            DataType dataType = SQLUtil.sqlTypeToDataType(columnType);
            FieldDescription<?> description = dataType.getDefaultDescription();
            dataBuilder.colType(c, description);
        }
        MetaCSVData metaCSVData = dataBuilder.build();
        return metaCSVData;
    }

    public void writeCSV(MetaCSVWriter writer) throws SQLException, IOException, MetaCSVDataException {
        this.writeCSV(writer, new MetaCSVDataBuilder());
    }

    private void writeCSV(MetaCSVWriter writer, MetaCSVDataBuilder dataBuilder) throws SQLException, MetaCSVDataException, IOException {
        MetaCSVData metaCSVData = this.getMetaCSVData(dataBuilder);
        this.writeCSV(writer, metaCSVData);
    }

    private void writeCSV(MetaCSVWriter writer, MetaCSVData metaCSVData) throws SQLException, IOException {
        List<String> header = this.getHeader();
        int count = header.size();
        writer.writeHeader(header);
        while (this.resultSet.next()) {
            List<Object> values = this.getRow(metaCSVData, count);
            writer.writeRow(values);
        }
        writer.close();
    }

    public List<String> getHeader() throws SQLException {
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        int count = metaData.getColumnCount();
        ArrayList<String> header = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            header.add(metaData.getColumnName(i + 1));
        }
        return header;
    }

    private List<Object> getRow(MetaCSVData metaCSVData, int count) throws SQLException {
        ArrayList<Object> values = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            Object value;
            DataType dataType = metaCSVData.getDescription(i).getDataType();
            switch (dataType) {
                case BOOLEAN: {
                    value = this.resultSet.getBoolean(i + 1);
                    break;
                }
                case CURRENCY_DECIMAL: 
                case DECIMAL: 
                case PERCENTAGE_DECIMAL: {
                    value = this.resultSet.getBigDecimal(i + 1);
                    break;
                }
                case CURRENCY_INTEGER: 
                case INTEGER: {
                    value = this.resultSet.getLong(i + 1);
                    break;
                }
                case DATE: {
                    value = this.resultSet.getDate(i + 1);
                    break;
                }
                case DATETIME: {
                    value = this.resultSet.getTime(i + 1);
                    break;
                }
                case FLOAT: 
                case PERCENTAGE_FLOAT: {
                    value = this.resultSet.getDouble(i + 1);
                    break;
                }
                case TEXT: {
                    value = this.resultSet.getString(i + 1);
                    break;
                }
                default: {
                    value = this.resultSet.getObject(i + 1);
                }
            }
            values.add(value);
        }
        return values;
    }
}

