/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.tool;

import com.github.jferard.javamcsv.DataType;
import java.sql.SQLException;

public class SQLUtil {
    public static int dataTypeToSQLType(DataType dataType) throws SQLException {
        switch (dataType) {
            case OBJECT: {
                return 2000;
            }
            case TEXT: {
                return 12;
            }
            case BOOLEAN: {
                return 16;
            }
            case CURRENCY_DECIMAL: 
            case DECIMAL: 
            case PERCENTAGE_DECIMAL: {
                return 3;
            }
            case FLOAT: 
            case PERCENTAGE_FLOAT: {
                return 8;
            }
            case DATE: 
            case DATETIME: {
                return 91;
            }
            case CURRENCY_INTEGER: 
            case INTEGER: {
                return 4;
            }
        }
        throw new SQLException();
    }

    public static DataType sqlTypeToDataType(int sqlType) {
        DataType dt;
        switch (sqlType) {
            case 16: {
                dt = DataType.BOOLEAN;
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                dt = DataType.INTEGER;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                dt = DataType.FLOAT;
                break;
            }
            case 2: 
            case 3: {
                dt = DataType.DECIMAL;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                dt = DataType.TEXT;
                break;
            }
            case 91: 
            case 93: {
                dt = DataType.DATE;
                break;
            }
            case 92: {
                dt = DataType.DATETIME;
                break;
            }
            default: {
                dt = DataType.OBJECT;
            }
        }
        return dt;
    }
}

