/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVWriterBuilder;
import com.github.jferard.javamcsv.processor.WriteFieldProcessor;
import com.github.jferard.javamcsv.processor.WriteProcessorProvider;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVPrinter;

public class MetaCSVWriter
implements Closeable {
    private final WriteProcessorProvider writeProvider;
    private final CSVPrinter printer;

    public static MetaCSVWriter create(File csvFile, MetaCSVData data) throws IOException {
        return new MetaCSVWriterBuilder().csvFile(csvFile).metaData(data).build();
    }

    public static MetaCSVWriter create(File csvFile, File metaCSVFile, MetaCSVData data) throws IOException {
        return new MetaCSVWriterBuilder().csvFile(csvFile).metaCSVFile(metaCSVFile).metaData(data).build();
    }

    public static MetaCSVWriter create(OutputStream out, OutputStream metaOut, MetaCSVData data) throws IOException {
        return new MetaCSVWriterBuilder().out(out).metaOut(metaOut).metaData(data).build();
    }

    public static MetaCSVWriter create(OutputStream out, MetaCSVData data) throws IOException {
        return new MetaCSVWriterBuilder().out(out).metaData(data).build();
    }

    protected MetaCSVWriter(CSVPrinter printer, WriteProcessorProvider writeProvider) {
        this.printer = printer;
        this.writeProvider = writeProvider;
    }

    @Override
    public void close() throws IOException {
        this.printer.close();
    }

    public void writeHeader(List<String> header) throws IOException {
        this.printer.printRecord(header);
    }

    public void writeRow(List<Object> values) throws IOException {
        ArrayList<String> formattedValues = new ArrayList<String>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            WriteFieldProcessor processor = this.writeProvider.getProcessor(i);
            String formattedValue = processor.toString(value);
            formattedValues.add(formattedValue);
        }
        this.printer.printRecord(formattedValues);
    }
}

