/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.description;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import com.github.jferard.javamcsv.processor.ObjectFieldProcessor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ObjectFieldDescription
implements FieldDescription<Object> {
    public static final FieldDescription<?> INSTANCE = new ObjectFieldDescription(Collections.<String>emptyList());
    private final String nullValue;
    private List<String> parameters;

    public ObjectFieldDescription(List<String> parameters) {
        this.parameters = parameters;
        this.nullValue = "";
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    public void render(Appendable out) throws IOException {
        out.append("object");
        if (this.parameters.size() > 0) {
            out.append('/');
            Util.render(out, this.parameters.toArray(new String[0]));
        }
    }

    @Override
    public FieldProcessor<Object> toFieldProcessor(String nullValue) {
        return new ObjectFieldProcessor(nullValue);
    }

    @Override
    public Class<Object> getJavaType() {
        return Object.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.OBJECT;
    }

    public String toString() {
        return String.format("ObjectFieldDescription(%s)", this.parameters);
    }
}

