/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.tool;

import com.github.jferard.javamcsv.DataType;
import java.sql.SQLException;

public class SQLUtil {
    public static int dataTypeToSQLType(DataType dataType) throws SQLException {
        int t = 0;
        switch (dataType) {
            case OBJECT: {
                t = 2000;
                break;
            }
            case TEXT: {
                t = 12;
                break;
            }
            case BOOLEAN: {
                t = 16;
                break;
            }
            case CURRENCY_DECIMAL: 
            case DECIMAL: 
            case PERCENTAGE_DECIMAL: {
                t = 3;
                break;
            }
            case FLOAT: 
            case PERCENTAGE_FLOAT: {
                t = 8;
                break;
            }
            case DATE: {
                t = 91;
                break;
            }
            case DATETIME: {
                t = 93;
                break;
            }
            case CURRENCY_INTEGER: 
            case INTEGER: {
                t = 4;
            }
        }
        return t;
    }

    public static DataType sqlTypeToDataType(int sqlType) {
        DataType dt;
        switch (sqlType) {
            case 16: {
                dt = DataType.BOOLEAN;
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                dt = DataType.INTEGER;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                dt = DataType.FLOAT;
                break;
            }
            case 2: 
            case 3: {
                dt = DataType.DECIMAL;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                dt = DataType.TEXT;
                break;
            }
            case 91: {
                dt = DataType.DATE;
                break;
            }
            case 92: 
            case 93: {
                dt = DataType.DATETIME;
                break;
            }
            default: {
                dt = DataType.OBJECT;
            }
        }
        return dt;
    }
}

