/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.MetaCSVParseException;
import com.github.jferard.javamcsv.ObjectTypeParser;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.description.BooleanFieldDescription;
import com.github.jferard.javamcsv.description.CurrencyDecimalFieldDescription;
import com.github.jferard.javamcsv.description.CurrencyIntegerFieldDescription;
import com.github.jferard.javamcsv.description.DateFieldDescription;
import com.github.jferard.javamcsv.description.DatetimeFieldDescription;
import com.github.jferard.javamcsv.description.DecimalFieldDescription;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.description.FloatFieldDescription;
import com.github.jferard.javamcsv.description.IntegerFieldDescription;
import com.github.jferard.javamcsv.description.PercentageDecimalFieldDescription;
import com.github.jferard.javamcsv.description.PercentageFloatFieldDescription;
import com.github.jferard.javamcsv.description.TextFieldDescription;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class ColTypeParser {
    private final ObjectTypeParser objectParser;

    public ColTypeParser(ObjectTypeParser objectParser) {
        this.objectParser = objectParser;
    }

    public FieldDescription<?> parseColType(String value) throws MetaCSVParseException {
        FieldDescription<Object> fieldDescription;
        List<String> values = Util.parse(value);
        String valueType = values.get(0);
        List<String> parameters = values.subList(1, values.size());
        if (valueType.equals("boolean")) {
            fieldDescription = this.parseBoolean(parameters);
        } else if (valueType.equals("currency")) {
            fieldDescription = this.parseCurrency(parameters);
        } else if (valueType.equals("date")) {
            fieldDescription = this.parseDate(parameters);
        } else if (valueType.equals("datetime")) {
            fieldDescription = this.parseDatetime(parameters);
        } else if (valueType.equals("decimal")) {
            fieldDescription = this.parseDecimal(parameters);
        } else if (valueType.equals("float")) {
            fieldDescription = this.parseFloat(parameters);
        } else if (valueType.equals("integer")) {
            fieldDescription = this.parseInteger(parameters);
        } else if (valueType.equals("percentage")) {
            fieldDescription = this.parsePercentage(parameters);
        } else if (valueType.equals("text")) {
            fieldDescription = TextFieldDescription.INSTANCE;
        } else if (valueType.equals("object")) {
            fieldDescription = this.objectParser.parse(parameters);
        } else {
            throw new MetaCSVParseException("Unknown col n type: " + valueType);
        }
        return fieldDescription;
    }

    private FieldDescription<Boolean> parseBoolean(List<String> parameters) throws MetaCSVParseException {
        String falseWord;
        String trueWord;
        if (parameters.size() == 1) {
            trueWord = parameters.get(0);
            falseWord = "";
        } else if (parameters.size() == 2) {
            trueWord = parameters.get(0);
            falseWord = parameters.get(1);
        } else {
            throw new MetaCSVParseException("Bad boolean format! " + parameters);
        }
        return new BooleanFieldDescription(trueWord, falseWord);
    }

    private FieldDescription<? extends Number> parseCurrency(List<String> parameters) throws MetaCSVParseException {
        boolean pre = this.parsePre(parameters.get(0));
        String symbol = parameters.get(1);
        String numberType = parameters.get(2);
        if (numberType.equals("integer")) {
            FieldDescription<Long> numberDescription = this.parseInteger(parameters.subList(3, parameters.size()));
            return new CurrencyIntegerFieldDescription(pre, symbol, numberDescription);
        }
        if (numberType.equals("decimal")) {
            FieldDescription<BigDecimal> numberDescription = this.parseDecimal(parameters.subList(3, parameters.size()));
            return new CurrencyDecimalFieldDescription(pre, symbol, numberDescription);
        }
        throw new MetaCSVParseException("Unknown currency number type: " + parameters);
    }

    private FieldDescription<Date> parseDate(List<String> parameters) throws MetaCSVParseException {
        if (parameters.size() == 1) {
            String format = parameters.get(0);
            return DateFieldDescription.create(format);
        }
        if (parameters.size() == 2) {
            String format = parameters.get(0);
            String locale = parameters.get(1);
            return DateFieldDescription.create(format, locale);
        }
        throw new MetaCSVParseException("Unknown date field: " + parameters);
    }

    private FieldDescription<Date> parseDatetime(List<String> parameters) throws MetaCSVParseException {
        if (parameters.size() == 1) {
            String format = parameters.get(0);
            return DatetimeFieldDescription.create(format);
        }
        if (parameters.size() == 2) {
            String format = parameters.get(0);
            String locale = parameters.get(1);
            return DatetimeFieldDescription.create(format, locale);
        }
        throw new MetaCSVParseException("Unknown datetime field: " + parameters);
    }

    private FieldDescription<Double> parseFloat(List<String> parameters) throws MetaCSVParseException {
        if (parameters.size() == 2) {
            return new FloatFieldDescription(parameters.get(0), parameters.get(1));
        }
        throw new MetaCSVParseException("Unknown integer field: " + parameters);
    }

    private FieldDescription<BigDecimal> parseDecimal(List<String> parameters) throws MetaCSVParseException {
        if (parameters.size() == 2) {
            return new DecimalFieldDescription(parameters.get(0), parameters.get(1));
        }
        throw new MetaCSVParseException("Unknown integer field: " + parameters);
    }

    private FieldDescription<Long> parseInteger(List<String> parameters) throws MetaCSVParseException {
        if (parameters.size() == 0) {
            return IntegerFieldDescription.INSTANCE;
        }
        if (parameters.size() == 1) {
            return new IntegerFieldDescription(parameters.get(0));
        }
        throw new MetaCSVParseException("Unknown integer field: " + parameters);
    }

    private boolean parsePre(String prePost) throws MetaCSVParseException {
        if (prePost.equals("pre")) {
            return true;
        }
        if (prePost.equals("post")) {
            return false;
        }
        throw new MetaCSVParseException("Unknown pre/post: " + prePost);
    }

    private FieldDescription<? extends Number> parsePercentage(List<String> parameters) throws MetaCSVParseException {
        boolean pre = this.parsePre(parameters.get(0));
        String symbol = parameters.get(1);
        String numberType = parameters.get(2);
        if (numberType.equals("float")) {
            FieldDescription<Double> numberDescription = this.parseFloat(parameters.subList(3, parameters.size()));
            return new PercentageFloatFieldDescription(pre, symbol, numberDescription);
        }
        if (numberType.equals("decimal")) {
            FieldDescription<BigDecimal> numberDescription = this.parseDecimal(parameters.subList(3, parameters.size()));
            return new PercentageDecimalFieldDescription(pre, symbol, numberDescription);
        }
        throw new MetaCSVParseException("Unknown currency number type: " + parameters);
    }
}

