/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.CSVParameters;
import com.github.jferard.javamcsv.MetaCSVDataBuilder;
import com.github.jferard.javamcsv.MetaCSVDataException;
import com.github.jferard.javamcsv.MetaCSVMetaData;
import com.github.jferard.javamcsv.OnError;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import com.github.jferard.javamcsv.processor.ProcessorProvider;
import com.github.jferard.javamcsv.processor.ReadProcessorProvider;
import com.github.jferard.javamcsv.processor.TextFieldProcessor;
import com.github.jferard.javamcsv.processor.WriteProcessorProvider;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaCSVData
implements CSVParameters {
    public static MetaCSVData DEFAULT;
    private final boolean doubleQuote;
    private final char escapeChar;
    private final char quoteChar;
    private final boolean skipInitialSpace;
    private final Map<Integer, FieldDescription<?>> descriptionByColIndex;
    private String nullValue;
    private String metaVersion;
    private Map<String, String> meta;
    private Charset encoding;
    private char delimiter;
    private boolean utf8BOM;
    private String lineTerminator;
    private Map<Integer, FieldProcessor<?>> processorByIndex;
    private TextFieldProcessor textFieldProcessor;

    public MetaCSVData(String metaVersion, Map<String, String> meta, Charset encoding, boolean utf8BOM, String lineTerminator, char delimiter, char quoteChar, boolean doubleQuote, char escapeChar, boolean skipInitialSpace, String nullValue, Map<Integer, FieldDescription<?>> descriptionByColIndex) {
        this.metaVersion = metaVersion;
        this.meta = meta;
        this.encoding = encoding;
        this.utf8BOM = utf8BOM;
        this.lineTerminator = lineTerminator;
        this.delimiter = delimiter;
        this.doubleQuote = doubleQuote;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.skipInitialSpace = skipInitialSpace;
        this.nullValue = nullValue;
        this.descriptionByColIndex = descriptionByColIndex;
        this.processorByIndex = new HashMap();
        for (Map.Entry<Integer, FieldDescription<?>> entry : this.descriptionByColIndex.entrySet()) {
            this.processorByIndex.put(entry.getKey(), entry.getValue().toFieldProcessor(this.nullValue));
        }
        this.textFieldProcessor = new TextFieldProcessor(this.nullValue);
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public String getLineTerminator() {
        return this.lineTerminator;
    }

    @Override
    public char getDelimiter() {
        return this.delimiter;
    }

    public FieldDescription<?> getDescription(int c) {
        return this.descriptionByColIndex.get(c);
    }

    public String toString() {
        return "MetaCSVData(encoding=" + this.encoding + ", lineTerminator=" + Util.escapeLineTerminator(this.lineTerminator) + ", delimiter=" + this.delimiter + ", doubleQuote=" + this.doubleQuote + ", escapeChar=" + this.escapeChar + ", quoteChar=" + this.quoteChar + ", skipInitialSpace=" + this.skipInitialSpace + ", descriptionByColIndex=" + this.descriptionByColIndex + ")";
    }

    public boolean isUtf8BOM() {
        return this.utf8BOM;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    @Override
    public boolean isDoubleQuote() {
        return this.doubleQuote;
    }

    @Override
    public char getEscapeChar() {
        return this.escapeChar;
    }

    @Override
    public char getQuoteChar() {
        return this.quoteChar;
    }

    @Override
    public boolean isSkipInitialSpace() {
        return this.skipInitialSpace;
    }

    public MetaCSVMetaData getMetaData() {
        return MetaCSVMetaData.create(this.descriptionByColIndex);
    }

    public List<Integer> getSortedColIndices() {
        ArrayList<Integer> indices = new ArrayList<Integer>(this.descriptionByColIndex.keySet());
        Collections.sort(indices);
        return indices;
    }

    public String getMetaVersion() {
        return this.metaVersion;
    }

    public String getMeta(String key) {
        return this.meta.get(key);
    }

    public ReadProcessorProvider toReadProcessorProvider(OnError onError) {
        return new ReadProcessorProvider(this.descriptionByColIndex, this.nullValue, onError);
    }

    public WriteProcessorProvider toWriteProcessorProvider(OnError onError) {
        return new WriteProcessorProvider(this.descriptionByColIndex, this.nullValue, onError);
    }

    public ProcessorProvider toProcessorProvider(String nullValue) {
        return new ProcessorProvider(this.descriptionByColIndex, nullValue);
    }

    static {
        try {
            DEFAULT = new MetaCSVDataBuilder().build();
        }
        catch (MetaCSVDataException e) {
            throw new AssertionError((Object)e);
        }
    }
}

