/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.description;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.description.DecimalFieldDescription;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.processor.CurrencyDecimalFieldProcessor;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import java.io.IOException;
import java.math.BigDecimal;

public class CurrencyDecimalFieldDescription
implements FieldDescription<BigDecimal> {
    public static final FieldDescription<?> INSTANCE = new CurrencyDecimalFieldDescription(true, "$", DecimalFieldDescription.INSTANCE);
    private final boolean pre;
    private final String symbol;
    private final FieldDescription<BigDecimal> numberDescription;

    public CurrencyDecimalFieldDescription(boolean pre, String symbol, FieldDescription<BigDecimal> numberDescription) {
        this.pre = pre;
        this.symbol = symbol;
        this.numberDescription = numberDescription;
    }

    @Override
    public void render(Appendable out) throws IOException {
        Util.render(out, "currency", this.pre ? "pre" : "post", this.symbol);
        out.append('/');
        this.numberDescription.render(out);
    }

    @Override
    public FieldProcessor<BigDecimal> toFieldProcessor(String nullValue) {
        return new CurrencyDecimalFieldProcessor(this.pre, this.symbol, this.numberDescription.toFieldProcessor(nullValue), nullValue);
    }

    @Override
    public Class<BigDecimal> getJavaType() {
        return BigDecimal.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.CURRENCY_DECIMAL;
    }

    public String toString() {
        return String.format("CurrencyFieldDescription(%b, %s, %s)", this.pre, this.symbol, this.numberDescription.toString());
    }

    public String getCurrencySymbol() {
        return this.symbol;
    }
}

