/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import java.math.BigDecimal;

public class PercentageDecimalFieldProcessor
implements FieldProcessor<BigDecimal> {
    public static final BigDecimal HUNDRED = BigDecimal.valueOf(100L);
    private final boolean pre;
    private final String symbol;
    private final FieldProcessor<BigDecimal> numberProcessor;
    private final String nullValue;

    public PercentageDecimalFieldProcessor(boolean pre, String symbol, FieldProcessor<BigDecimal> numberProcessor, String nullValue) {
        this.pre = pre;
        this.symbol = symbol;
        this.numberProcessor = numberProcessor;
        this.nullValue = nullValue;
    }

    @Override
    public BigDecimal toObject(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return null;
        }
        text = Util.cleanCurrencyText(text, this.pre, this.symbol);
        return this.numberProcessor.toObject(text).divide(HUNDRED);
    }

    @Override
    public String toString(BigDecimal value) {
        if (value == null) {
            return this.nullValue;
        }
        String valueAsString = this.numberProcessor.toString(value.multiply(HUNDRED));
        if (this.pre) {
            return this.symbol + valueAsString;
        }
        return valueAsString + this.symbol;
    }

    @Override
    public String toCanonicalString(String text) throws MetaCSVReadException {
        BigDecimal value = this.toObject(text);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public BigDecimal cast(Object o) {
        return this.numberProcessor.cast(o);
    }
}

